package com.ruoyi.system.service.publicservice.impl;

import com.google.common.collect.Lists;
import com.ruoyi.common.constant.BsConstants;
import com.ruoyi.common.core.redis.PublicServiceRedisCache;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.BsUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.sql.Query;
import com.ruoyi.system.domain.publicservice.TOtherappAttachment;
import com.ruoyi.system.domain.publicservice.TPublicServiceIsound;
import com.ruoyi.system.domain.system.enums.AttachEnums;
import com.ruoyi.system.mapper.publicservice.TOtherappAttachmentMapper;
import com.ruoyi.system.mapper.publicservice.TPublicServiceIsoundMapper;
import com.ruoyi.system.service.publicservice.TOtherappAttachmentService;
import com.ruoyi.system.service.publicservice.TPublicServiceIsoundService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 公共服务 我发声表
 * @author wujm<wujm@eazytec.com>
 */
@Service
public class TPublicServiceIsoundServiceImpl implements TPublicServiceIsoundService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Resource
	private TPublicServiceIsoundMapper tPublicServiceIsoundMapper;

	@Autowired
	private PublicServiceRedisCache redisCache;

	@Autowired
	private TOtherappAttachmentService itOtherappAttachmentService;

	@Autowired
	private TOtherappAttachmentMapper tOtherappAttachmentMapper;

	/** 基础功能不要直接写实现 */
	/**
	* 列表
	* @return
	*/
	private List<TPublicServiceIsound> list(TPublicServiceIsound tPublicServiceIsound) {
		return tPublicServiceIsoundMapper.list(tPublicServiceIsound);
	}

	/**
	* 查询
	* @param id
	*/
	private TPublicServiceIsound getObjectById(Long id) {
		Query query = new Query();
		query.put("soundId",id);
		return tPublicServiceIsoundMapper.getObjectById(query);
	}

    /**
     * 分页查询
     * @param tPublicServiceIsound
     * @return
     */
	@Override
	public List<TPublicServiceIsound> listTPublicServiceIsound(TPublicServiceIsound tPublicServiceIsound) {
		return this.list(tPublicServiceIsound);
	}

    /**
     * 新增
     * @param tPublicServiceIsound
     * @return
     */
	@Override
	public int saveTPublicServiceIsound(TPublicServiceIsound tPublicServiceIsound) {
		return tPublicServiceIsoundMapper.save(tPublicServiceIsound);
	}

    /**
     * 根据id查询
     * @param id
     * @return
     */
	@Override
	public TPublicServiceIsound getTPublicServiceIsoundById(Long id) {
		return this.getObjectById(id);
	}

    /**
     * 修改
     * @param tPublicServiceIsound
     * @return
     */
	@Override
	public int updateTPublicServiceIsound(TPublicServiceIsound tPublicServiceIsound) {
		return tPublicServiceIsoundMapper.update(tPublicServiceIsound);
	}

    /**
     * 删除
     * @param ids
     * @return
     */
	@Override
	public int batchRemove(Long[] ids) {
		int count = 0;
		for(Long id:ids) {
			count += tPublicServiceIsoundMapper.remove(id);
		}
		return count;
	}

	@Override
	public String getMaxNum(){
		String numKey = BsUtils.getBsCacheKey(String.format("%s%s", BsConstants.CACHE_KEY_ISOUND_NO));
		String num = "";
		if (!redisCache.keys().exists(numKey)) {
			TPublicServiceIsound isound = new TPublicServiceIsound();
			isound = tPublicServiceIsoundMapper.getMaxNo(isound);

			if(null == isound || StringUtils.isNull(isound.getSoundCode())){
				num = "00001";
			}else{
				num = isound.getSoundCode().substring(isound.getSoundCode().length()-5,isound.getSoundCode().length());
			}
			redisCache.strings().setnx(numKey,Integer.parseInt(num));
		}
		redisCache.keys().expire(numKey,1,TimeUnit.DAYS);
		Long no = redisCache.strings().incrBy(numKey, 1L);
		return "FS"+BsUtils.formatMindNo(no,5);
	}

	/**
	 * 新增
	 * @param tPublicServiceIsound
	 * @return
	 */
	@Override
	@Transactional
	public int saveISound(TPublicServiceIsound tPublicServiceIsound) {
		tPublicServiceIsound.setSoundCode(this.getMaxNum());
		int result = tPublicServiceIsoundMapper.save(tPublicServiceIsound);
		if(!CollectionUtils.isEmpty(tPublicServiceIsound.getAttachmentList())){
			for(TOtherappAttachment attachment : tPublicServiceIsound.getAttachmentList()){
				attachment.setBusinessId(tPublicServiceIsound.getSoundId().toString());
				attachment.setAttachType(AttachEnums.AttachType.ISOUND.name());
				tOtherappAttachmentMapper.insertSelective(attachment);
			}
		}

		return result;
	}

	@Override
	public TPublicServiceIsound getIsoundById(Long id) {
		TPublicServiceIsound isound = this.getObjectById(id);

		if(null == isound){
			return null;
		}
		isound.setAttachmentList(itOtherappAttachmentService.listByBusinessIdAndType(Lists.newArrayList(id),AttachEnums.AttachType.ISOUND.name()));

		return isound;
	}

    @Override
    @Transactional
    public int updateIsound(TPublicServiceIsound tPublicServiceIsound, String realName) {
        TPublicServiceIsound isound = tPublicServiceIsoundMapper.getObjectById(tPublicServiceIsound.getSoundId());
        if(null == isound){
            throw new ServiceException("我发声记录不存在");
        }
        return tPublicServiceIsoundMapper.update(tPublicServiceIsound);
    }

}
