package com.ruoyi.party.service.impl;

import com.ruoyi.common.annotation.DataSource;
import com.ruoyi.common.enums.DataSourceType;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.party.domain.PartyBuildingNews;
import com.ruoyi.party.domain.vo.PartyBuildingNewsVO;
import com.ruoyi.party.mapper.PartyBuildingNewsMapper;
import com.ruoyi.party.service.api.IPartyBuildingNewsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 党建要闻Service业务层处理
 * 
 * @author ruoyi
 * @date 2024-05-24
 */
@Service
@DataSource(value = DataSourceType.SLAVE)
public class PartyBuildingNewsServiceImpl implements IPartyBuildingNewsService
{
    @Autowired
    private PartyBuildingNewsMapper partyBuildingNewsMapper;

    /**
     * 查询党建要闻
     * 
     * @param id 党建要闻主键
     * @return 党建要闻
     */
    @Override
    public PartyBuildingNews selectPartyBuildingNewsById(Long id)
    {
        return partyBuildingNewsMapper.selectPartyBuildingNewsById(id);
    }

    /**
     * 查询党建要闻列表
     * 
     * @param partyBuildingNews 党建要闻
     * @return 党建要闻
     */
    @Override
    public List<PartyBuildingNews> selectPartyBuildingNewsList(PartyBuildingNewsVO partyBuildingNews)
    {
        return partyBuildingNewsMapper.selectPartyBuildingNewsList(partyBuildingNews);
    }

    /**
     * 新增党建要闻
     * 
     * @param partyBuildingNews 党建要闻
     * @return 结果
     */
    @Override
    public int insertPartyBuildingNews(PartyBuildingNews partyBuildingNews)
    {
        partyBuildingNews.setCreateTime(DateUtils.getNowDate());
        return partyBuildingNewsMapper.insertPartyBuildingNews(partyBuildingNews);
    }

    /**
     * 修改党建要闻
     * 
     * @param partyBuildingNews 党建要闻
     * @return 结果
     */
    @Override
    public int updatePartyBuildingNews(PartyBuildingNews partyBuildingNews)
    {
        partyBuildingNews.setUpdateTime(DateUtils.getNowDate());
        return partyBuildingNewsMapper.updatePartyBuildingNews(partyBuildingNews);
    }

    /**
     * 批量删除党建要闻
     * 
     * @param ids 需要删除的党建要闻主键
     * @return 结果
     */
    @Override
    public int deletePartyBuildingNewsByIds(Long[] ids)
    {
        return partyBuildingNewsMapper.deletePartyBuildingNewsByIds(ids);
    }

    /**
     * 删除党建要闻信息
     * 
     * @param id 党建要闻主键
     * @return 结果
     */
    @Override
    public int deletePartyBuildingNewsById(Long id)
    {
        return partyBuildingNewsMapper.deletePartyBuildingNewsById(id);
    }
}
