package com.ruoyi.web.controller.publicservice;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.publicservice.TPublicServiceDiscuss;
import com.ruoyi.system.domain.publicservice.vo.PSTkCommonTaskVO;
import com.ruoyi.system.domain.task.TkCommonTask;
import com.ruoyi.system.service.publicservice.TPublicServiceDiscussService;
import com.ruoyi.system.service.task.TaskService;
import io.swagger.annotations.Api;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 公共服务 我发现表
 *
 * @author wangjie
 */
@Api(tags = "公共服务-万事好商量")
@RestController
@RequestMapping("/api/publicservice/discuss")
public class TPublicServiceDiscussController extends BaseController {

    @Autowired
    private TPublicServiceDiscussService tPublicServiceDiscussService;

    @Autowired
    private TaskService taskService;

    @GetMapping(value = "/getMaxNo")
    public AjaxResult getMaxNo() {
        return AjaxResult.success(tPublicServiceDiscussService.getMaxNum());
    }

    /**
     * 列表
     *
     * @param tPublicServiceDiscuss
     * @return
     */
    @GetMapping()
    public TableDataInfo list(TPublicServiceDiscuss tPublicServiceDiscuss) {
        startPage();
        return getDataTable(tPublicServiceDiscussService.listTPublicServiceDiscuss(tPublicServiceDiscuss));
    }

    /**
     * 新增
     *
     * @param tPublicServiceDiscuss
     * @return
     */
    @Log(title = "新增公共服务 万事好商量表", businessType = BusinessType.INSERT)
    @RepeatSubmit
    @PostMapping()
    public AjaxResult save(@Validated @RequestBody TPublicServiceDiscuss tPublicServiceDiscuss) {
        tPublicServiceDiscuss.setCreateBy(getUserId());
        return toAjax(tPublicServiceDiscussService.saveDiscuss(tPublicServiceDiscuss, getUserId()));
    }

    /**
     * 根据id查询详情
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getById(@PathVariable("id") Long id) {
        return AjaxResult.success(tPublicServiceDiscussService.getDiscussById(id));
    }

    /**
     * 修改
     *
     * @param tPublicServiceDiscuss
     * @return
     */
    @Log(title = "修改公共服务 我发现表", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult update(@Validated @RequestBody TPublicServiceDiscuss tPublicServiceDiscuss) {
        tPublicServiceDiscuss.setUpdateBy(getUserId());
        return toAjax(tPublicServiceDiscussService.updateDiscuss(tPublicServiceDiscuss, getUsername()));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Log(title = "删除公共服务 我发现表", businessType = BusinessType.DELETE)
    @DeleteMapping("/delete")
    public AjaxResult batchRemove(@RequestBody Long[] ids) {
        return toAjax(tPublicServiceDiscussService.batchRemove(ids));
    }

    /**
     * 转工单
     *
     * @param tkCommonTask
     * @return
     */
    @RequestMapping(value = "/transferTask", method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult add(@RequestBody PSTkCommonTaskVO tkCommonTask) {
        if (null == tkCommonTask.getFindOrDiscussId()) {
            throw new ServiceException("万事好商量id未传");
        }

        TPublicServiceDiscuss discuss = tPublicServiceDiscussService.getDiscussById(tkCommonTask.getFindOrDiscussId());
        if (null == discuss) {
            throw new ServiceException("万事好商量记录不存在");
        }

        TkCommonTask task = new TkCommonTask();
        BeanUtils.copyProperties(tkCommonTask, task);
        //工单来源（传对应数字） 1中心指派、2领导交办 、10事件上报、11民意收集、12隐患整改、网格上报（comefrom为null的）
        task.setComeFrom(10);
        //优先级（传对应数字）：0普通、1重要、2紧急
        task.setPriorityType(0);
        task.setFormId(tkCommonTask.getFindOrDiscussId().toString());
        task.setNum(tkCommonTask.getFindCode());
        String projectId = taskService.add(task);
        if (StringUtils.isEmpty(projectId)) {
            throw new ServiceException("转工单失败：未能获取工单id");
        }
        discuss.setDiscussId(tkCommonTask.getFindOrDiscussId());
        discuss.setProjectId(projectId);
        discuss.setGenTask("1");
        discuss.setDiscussResult("3");
        discuss.setProjectStatus("处理中");
        discuss.setProjectName(tkCommonTask.getTkName());
        int result = tPublicServiceDiscussService.updateTPublicServiceDiscuss(discuss);

        return toAjax(result);
    }
}
