package com.ruoyi.web.controller.common;

import com.easytec.oss.sdk.core.OssClient;
import com.easytec.oss.sdk.dto.EfsRequest;
import com.easytec.oss.sdk.dto.RequestResult;
import com.easytec.oss.sdk.dto.UploadRes;
import com.ruoyi.common.core.domain.AjaxResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.UUID;

/**
 * @author condey
 * @version $$package: com.ruoyi.web.controller.common, v 0.1 2024/6/12 10:57 AM condey Exp $$
 */
@Api(tags = "基础服务 - EFS文件上传")
@RestController
@RequestMapping("/efs")
public class EfsController {

    @Value("${app.zqt_id}")
    private String appId;

    @ApiOperation("图片/视频上传")
    @PostMapping(value = "upload", headers = "content-type=multipart/form-data")
    public AjaxResult upload(@ApiParam(name = "file", value = "上传文件", required = true)MultipartFile file) {

        OssClient ossClient = new OssClient("https://api-efs.eazytec-cloud.com");
        String fileName = file.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        File tempFile;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), prefix);
            file.transferTo(tempFile);
            EfsRequest efsRequest = new EfsRequest();
            efsRequest.setAppId(appId);
            efsRequest.setFileName(fileName);
            efsRequest.setLiveDay(0);
            /**同步上传(随机路径)**/
            RequestResult<UploadRes> result = ossClient.syncUpload(tempFile, efsRequest);
            return AjaxResult.success(result.getData());
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error("上传文件失败");
        }
    }
}
