package com.ruoyi.web.controller.md;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.system.domain.md.dto.UnionInboxDto;
import com.ruoyi.system.domain.md.request.NewMsgQuery;
import com.ruoyi.system.service.md.NewmsgAppService;
import com.ruoyi.system.service.md.NewMsgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author vidar
 * date 2024/6/5
 * description 消息中心
 **/
@Api(tags = "消息")
@RestController
@RequestMapping("/api/md/msgcenter")
public class MsgCenterController {
    @Resource
    private NewmsgAppService newmsgAppService;
    @Resource
    private NewMsgService newMsgService;

    @ApiOperation("查询所有分类的收件箱")
    @RequestMapping(value = "/query/union/inbox", method = RequestMethod.GET)
    @ResponseBody
    public R<IPage<UnionInboxDto>> queryUnion(NewMsgQuery query) {
        return R.ok(newmsgAppService.queryUnion(query));
    }

    @ApiOperation("获取收件消息详情")
    @RequestMapping(value = "/detail/inbox/{inboxid}", method = RequestMethod.GET)
    @ResponseBody
    public R<Map<String,Object>> detail(@PathVariable("inboxid") String inboxid) {
        if (StringUtils.isBlank(inboxid)){
            throw new ServiceException("参数异常");
        }
        return R.ok(newMsgService.getInboxDetail4Map(inboxid));
    }

    @ApiOperation("用户阅读收件消息")
    @RequestMapping(value = "/read/{inboxid}", method = RequestMethod.POST)
    @ResponseBody
    public R<String> read(@PathVariable("inboxid") String inboxid) {
        if (StringUtils.isBlank(inboxid)){
            throw new ServiceException("参数异常");
        }
        newMsgService.readInbox(inboxid);
        return R.ok();
    }


    @ApiOperation("用户阅读收件消息")
    @RequestMapping(value = "/read/batch", method = RequestMethod.POST)
    @ResponseBody
    public R<String> read(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            throw new ServiceException("参数异常");
        }
        NewMsgQuery query = new NewMsgQuery();
        query.setInboxids(ids);
        newMsgService.readInbox(null,query);
        return R.ok();
    }


    @ApiOperation("用户阅读分类下全部消息")
    @RequestMapping(value = "/read/all/{msgtype}", method = RequestMethod.POST)
    @ResponseBody
    public R<String> readAll(@PathVariable("msgtype") Byte msgtype,@RequestBody NewMsgQuery query) {
        if (msgtype==null || StringUtils.isBlank(query.getToUserid()) || query.getToUsertype()==null){
            throw new ServiceException("参数异常");
        }
        newMsgService.readInbox(msgtype,query);
        return R.ok();
    }


    @ApiOperation("用户阅读分类下全部消息")
    @RequestMapping(value = "/read/all", method = RequestMethod.POST)
    @ResponseBody
    public R<String> readAll(@RequestBody NewMsgQuery query) {
        if (StringUtils.isBlank(query.getToUserid())){
            throw new ServiceException("参数异常");
        }
        newMsgService.readInbox(null,query);
        return R.ok();
    }
}
