package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridHouse;
import com.ruoyi.system.domain.grid.GridHouseInterview;
import com.ruoyi.system.domain.grid.GridHousePeople;
import com.ruoyi.system.domain.grid.ext.GridHouseExt;
import com.ruoyi.system.domain.grid.ext.GridHousePeopleExt;
import com.ruoyi.system.domain.grid.vo.GridHouseSearchParam;
import com.ruoyi.system.service.grid.GridHouseInterviewService;
import com.ruoyi.system.service.grid.GridHousePeopleService;
import com.ruoyi.system.service.grid.GridHouseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;

/**
 * @author : peter
 * @description: TODO
 * @date : 2022-05-04 10:24
 */
@Api(tags = "网格管理 - 房屋管理")
@RestController
@RequestMapping("/api/grid/house")
public class HouseController {

    @Autowired
    private GridHouseService gridHouseService;
    @Autowired
    private GridHousePeopleService gridHousePeopleService;
    @Autowired
    private GridHouseInterviewService gridHouseInterviewService;

    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public AjaxResult list(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                           @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                           @RequestParam(value = "wgCode", required = false) String wgCode,
                           @RequestParam(value = "fwlxCode", required = false) String fwlxCode,
                           @RequestParam(value = "fwztCode", required = false) String fwztCode,
                           @RequestParam(value = "houseName", required = false) String houseName,
                           @RequestParam(value = "value", required = false) String value) {
        try {
            GridHouseSearchParam wsHouse = new GridHouseSearchParam();
            if(StringUtils.isNotBlank(wgCode)){
                wsHouse.setWgCodeLikes(Arrays.asList(wgCode.split(",")));
            }
            wsHouse.setFwlxCode(fwlxCode);
            wsHouse.setFwztCode(fwztCode);
            wsHouse.setHouseName(houseName);
            PageHelper.startPage(pageNum, pageSize);
            PageInfo<GridHouseExt> pageInfo = gridHouseService.page(wsHouse, value);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/add")
    public AjaxResult add(@RequestBody GridHouse wsHouse) {
        return gridHouseService.add(wsHouse);
    }

    /**
     * 修改
     */
    @PostMapping(value = "/edit")
    public AjaxResult edit(@RequestBody GridHouse wsHouse) {
        return gridHouseService.edit(wsHouse);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") String id) {
        return gridHouseService.detail(id);
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/delete")
    public AjaxResult delete(@RequestParam(value = "id") String id) {
        return gridHouseService.delete(id);
    }

    /**
     * 房屋关联人口信息
     */
    @GetMapping(value = "/houseToPeoplePage")
    public AjaxResult houseToPeoplePage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                        @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                        @RequestParam(value = "houseId") String houseId) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            PageInfo<GridHousePeopleExt> pageInfo = gridHouseService.houseToPeoplePage(houseId);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 房屋绑定人口信息
     */
    @PostMapping(value = "/houseBindPeople")
    public AjaxResult houseBindPeople(@RequestBody GridHousePeople wsHousePeople) {
        return gridHouseService.houseBindPeople(wsHousePeople);
    }

    /**
     * 房屋解绑人口信息
     */
    @GetMapping(value = "/houseUnbindPeople")
    public AjaxResult houseUnbindPeople(@RequestParam(value = "id") String id) {
        gridHousePeopleService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }

    /**
     * 房屋信息excel导入
     */
    @PostMapping(value = "import", headers = "content-type=multipart/form-data")
    public AjaxResult importExcel(@RequestParam(value = "file") MultipartFile file,
                                  @RequestParam(value = "createId") String createId) {
        return gridHouseService.importExcel(file, createId);
    }

    /**
     * 房屋走访日志列表
     */
    @GetMapping(value = "/interview/page")
    public AjaxResult interviewPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                    @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                    @RequestParam(value = "houseId") String houseId) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            PageInfo<GridHouseInterview> pageInfo = new PageInfo<>(gridHouseInterviewService.interviewPage(houseId));
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 房屋走访日志新增
     */
    @PostMapping(value = "/interview/add")
    public AjaxResult interviewAdd(@RequestBody GridHouseInterview wsHouseInterview) {
        return AjaxResult.success(gridHouseInterviewService.interviewAdd(wsHouseInterview));
    }

    /**
     * 房屋走访日志详情
     */
    @GetMapping(value = "interview/detail/{id}")
    public AjaxResult interviewDetail(@PathVariable("id") String id) {
        return AjaxResult.success(gridHouseInterviewService.detail(id));
    }

    @ApiOperation("所有房屋列表")
    @GetMapping("/allHouseList")
    public AjaxResult getHouseList(){
        return AjaxResult.success(gridHouseService.getAllHouseList());
    }

}
