package com.ruoyi.web.controller.zb;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.grid.ext.GridCompanyExt;
import com.ruoyi.system.domain.zb.enums.ZbSpecialWorkEnum;
import com.ruoyi.system.domain.zb.request.SpecialWorkSaveRequest;
import com.ruoyi.system.domain.zb.vo.SpecialWorkVO;
import com.ruoyi.system.service.grid.GridRegionUserService;
import com.ruoyi.system.service.zb.SpecialWorkService;
import io.swagger.annotations.Api;
import org.aspectj.weaver.loadtime.Aj;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * * Author: brenda
 * * 2025/1/8
 **/
@Api(tags = "专项工作")
@RestController
@RequestMapping("/api/zb/work")
public class SpecialWorkController extends BaseController {

    @Autowired
    private SpecialWorkService specialWorkService;
    @Autowired
    private GridRegionUserService gridRegionUserService;

    @PostMapping("/special/save")
    public AjaxResult saveSpecialWork(@RequestBody SpecialWorkSaveRequest request){
        if(CollectionUtils.isEmpty(request.getUserIdList())){
            return AjaxResult.error("发布范围不能为空！");
        }
        request.setType(ZbSpecialWorkEnum.SPECIAL_WORK.getCode());
        sameSave(request);
        return AjaxResult.success();
    }

    private void sameSave(SpecialWorkSaveRequest request){
        SysUser sysUser = getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateUserName(sysUser.getNickName());
        request.setValid((byte) 1);
        GridRegionUser gridRegionUser = gridRegionUserService.selectByUserId(sysUser.getUserId());
        if(gridRegionUser != null){
            request.setWgCode(gridRegionUser.getWgId());
        }
        specialWorkService.save(request);
    }

    @GetMapping("/delete")
    public AjaxResult deleteSpecialWork(@RequestParam("id") String id){
        specialWorkService.delete(id);
        return AjaxResult.success();
    }

    @PostMapping("/special/update")
    public AjaxResult updateSpecialWork(@RequestBody SpecialWorkSaveRequest request){
        if(CollectionUtils.isEmpty(request.getUserIdList()) || StringUtils.isBlank(request.getId())){
            return AjaxResult.error("参数错误！");
        }
        request.setType(ZbSpecialWorkEnum.SPECIAL_WORK.getCode());
        sameUpdate(request);
        return AjaxResult.success();
    }

    private void sameUpdate(SpecialWorkSaveRequest request){
        SysUser sysUser = getLoginUser().getUser();
        request.setUpdateUser(sysUser.getUserId());
        request.setUpdateUserName(sysUser.getNickName());
        request.setUpdateTime(new Date());
        specialWorkService.update(request);
    }

    @GetMapping("/detail/{id}")
    public AjaxResult detail(@PathVariable("id") String id){
        return AjaxResult.success(specialWorkService.detail(id));
    }

    @GetMapping("/special/page")
    public AjaxResult specialWorkPage(@RequestParam("pageNum") int pageNum, @RequestParam("pageSize") int pageSize,
                                      @RequestParam(value = "title", required = false)String title,
                                      @RequestParam(value = "userName", required = false)String userName){
        SysUser sysUser = getLoginUser().getUser();
        String userId = "";
        if(!sysUser.isAdmin()){
            userId = sysUser.getUserId();
        }
        PageHelper.startPage(pageNum, pageSize);
        PageInfo<SpecialWorkVO> pageInfo = specialWorkService.page(title, userName, ZbSpecialWorkEnum.SPECIAL_WORK.getCode(), userId);
        return AjaxResult.success(pageInfo);
    }
}
