/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.alibaba.deps.org.objectweb.asm.Type;
import com.taobao.arthas.core.command.model.ClassDetailVO;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.ClassVO;
import com.taobao.arthas.core.command.model.MethodVO;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClassUtils {
    public static String getCodeSource(CodeSource cs) {
        if (null == cs || null == cs.getLocation() || null == cs.getLocation().getFile()) {
            return "";
        }
        return cs.getLocation().getFile();
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        return clazz.getName().contains("$$Lambda$");
    }

    public static Element renderClassInfo(ClassDetailVO clazz) {
        return ClassUtils.renderClassInfo(clazz, false, null);
    }

    public static Element renderClassInfo(ClassDetailVO clazz, boolean isPrintField, Integer expand) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(Element.label("class-info").style(Decoration.bold.bold()), Element.label(clazz.getClassInfo())).row(Element.label("code-source").style(Decoration.bold.bold()), Element.label(clazz.getCodeSource())).row(Element.label("name").style(Decoration.bold.bold()), Element.label(clazz.getName())).row(Element.label("isInterface").style(Decoration.bold.bold()), Element.label("" + clazz.isInterface())).row(Element.label("isAnnotation").style(Decoration.bold.bold()), Element.label("" + clazz.isAnnotation())).row(Element.label("isEnum").style(Decoration.bold.bold()), Element.label("" + clazz.isEnum())).row(Element.label("isAnonymousClass").style(Decoration.bold.bold()), Element.label("" + clazz.isAnonymousClass())).row(Element.label("isArray").style(Decoration.bold.bold()), Element.label("" + clazz.isArray())).row(Element.label("isLocalClass").style(Decoration.bold.bold()), Element.label("" + clazz.isLocalClass())).row(Element.label("isMemberClass").style(Decoration.bold.bold()), Element.label("" + clazz.isMemberClass())).row(Element.label("isPrimitive").style(Decoration.bold.bold()), Element.label("" + clazz.isPrimitive())).row(Element.label("isSynthetic").style(Decoration.bold.bold()), Element.label("" + clazz.isSynthetic())).row(Element.label("simple-name").style(Decoration.bold.bold()), Element.label(clazz.getSimpleName())).row(Element.label("modifier").style(Decoration.bold.bold()), Element.label(clazz.getModifier())).row(Element.label("annotation").style(Decoration.bold.bold()), Element.label(StringUtils.join(clazz.getAnnotations(), ","))).row(Element.label("interfaces").style(Decoration.bold.bold()), Element.label(StringUtils.join(clazz.getInterfaces(), ","))).row(Element.label("super-class").style(Decoration.bold.bold()), TypeRenderUtils.drawSuperClass(clazz)).row(Element.label("class-loader").style(Decoration.bold.bold()), TypeRenderUtils.drawClassLoader(clazz)).row(Element.label("classLoaderHash").style(Decoration.bold.bold()), Element.label(clazz.getClassLoaderHash()));
        if (isPrintField) {
            table.row(Element.label("fields").style(Decoration.bold.bold()), TypeRenderUtils.drawField(clazz, expand));
        }
        return table;
    }

    public static ClassDetailVO createClassInfo(Class clazz, boolean withFields) {
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        ClassDetailVO classInfo = new ClassDetailVO();
        classInfo.setName(StringUtils.classname(clazz));
        classInfo.setClassInfo(StringUtils.classname(clazz));
        classInfo.setCodeSource(ClassUtils.getCodeSource(cs));
        classInfo.setInterface(clazz.isInterface());
        classInfo.setAnnotation(clazz.isAnnotation());
        classInfo.setEnum(clazz.isEnum());
        classInfo.setAnonymousClass(clazz.isAnonymousClass());
        classInfo.setArray(clazz.isArray());
        classInfo.setLocalClass(clazz.isLocalClass());
        classInfo.setMemberClass(clazz.isMemberClass());
        classInfo.setPrimitive(clazz.isPrimitive());
        classInfo.setSynthetic(clazz.isSynthetic());
        classInfo.setSimpleName(clazz.getSimpleName());
        classInfo.setModifier(StringUtils.modifier(clazz.getModifiers(), ','));
        classInfo.setAnnotations(TypeRenderUtils.getAnnotations(clazz));
        classInfo.setInterfaces(TypeRenderUtils.getInterfaces(clazz));
        classInfo.setSuperClass(TypeRenderUtils.getSuperClass(clazz));
        classInfo.setClassloader(TypeRenderUtils.getClassloader(clazz));
        classInfo.setClassLoaderHash(StringUtils.classLoaderHash(clazz));
        if (withFields) {
            classInfo.setFields(TypeRenderUtils.getFields(clazz));
        }
        return classInfo;
    }

    public static ClassVO createSimpleClassInfo(Class clazz) {
        ClassVO classInfo = new ClassVO();
        ClassUtils.fillSimpleClassVO(clazz, classInfo);
        return classInfo;
    }

    public static void fillSimpleClassVO(Class clazz, ClassVO classInfo) {
        classInfo.setName(StringUtils.classname(clazz));
        classInfo.setClassloader(TypeRenderUtils.getClassloader(clazz));
        classInfo.setClassLoaderHash(StringUtils.classLoaderHash(clazz));
    }

    public static MethodVO createMethodInfo(Method method, Class clazz, boolean detail) {
        MethodVO methodVO = new MethodVO();
        methodVO.setDeclaringClass(clazz.getName());
        methodVO.setMethodName(method.getName());
        methodVO.setDescriptor(Type.getMethodDescriptor(method));
        methodVO.setConstructor(false);
        if (detail) {
            methodVO.setModifier(StringUtils.modifier(method.getModifiers(), ','));
            methodVO.setAnnotations(TypeRenderUtils.getAnnotations(method.getDeclaredAnnotations()));
            methodVO.setParameters(ClassUtils.getClassNameList(method.getParameterTypes()));
            methodVO.setReturnType(StringUtils.classname(method.getReturnType()));
            methodVO.setExceptions(ClassUtils.getClassNameList(method.getExceptionTypes()));
            methodVO.setClassLoaderHash(StringUtils.classLoaderHash(clazz));
        }
        return methodVO;
    }

    public static MethodVO createMethodInfo(Constructor constructor, Class clazz, boolean detail) {
        MethodVO methodVO = new MethodVO();
        methodVO.setDeclaringClass(clazz.getName());
        methodVO.setDescriptor(Type.getConstructorDescriptor(constructor));
        methodVO.setMethodName("<init>");
        methodVO.setConstructor(true);
        if (detail) {
            methodVO.setModifier(StringUtils.modifier(constructor.getModifiers(), ','));
            methodVO.setAnnotations(TypeRenderUtils.getAnnotations(constructor.getDeclaredAnnotations()));
            methodVO.setParameters(ClassUtils.getClassNameList(constructor.getParameterTypes()));
            methodVO.setExceptions(ClassUtils.getClassNameList(constructor.getExceptionTypes()));
            methodVO.setClassLoaderHash(StringUtils.classLoaderHash(clazz));
        }
        return methodVO;
    }

    public static Element renderMethod(MethodVO method) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(Element.label("declaring-class").style(Decoration.bold.bold()), Element.label(method.getDeclaringClass())).row(Element.label("method-name").style(Decoration.bold.bold()), Element.label(method.getMethodName()).style(Decoration.bold.bold())).row(Element.label("modifier").style(Decoration.bold.bold()), Element.label(method.getModifier())).row(Element.label("annotation").style(Decoration.bold.bold()), Element.label(TypeRenderUtils.drawAnnotation(method.getAnnotations()))).row(Element.label("parameters").style(Decoration.bold.bold()), Element.label(TypeRenderUtils.drawParameters(method.getParameters()))).row(Element.label("return").style(Decoration.bold.bold()), Element.label(method.getReturnType())).row(Element.label("exceptions").style(Decoration.bold.bold()), Element.label(TypeRenderUtils.drawExceptions(method.getExceptions()))).row(Element.label("classLoaderHash").style(Decoration.bold.bold()), Element.label(method.getClassLoaderHash()));
        return table;
    }

    public static Element renderConstructor(MethodVO constructor) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(Element.label("declaring-class").style(Decoration.bold.bold()), Element.label(constructor.getDeclaringClass())).row(Element.label("constructor-name").style(Decoration.bold.bold()), Element.label("<init>").style(Decoration.bold.bold())).row(Element.label("modifier").style(Decoration.bold.bold()), Element.label(constructor.getModifier())).row(Element.label("annotation").style(Decoration.bold.bold()), Element.label(TypeRenderUtils.drawAnnotation(constructor.getAnnotations()))).row(Element.label("parameters").style(Decoration.bold.bold()), Element.label(TypeRenderUtils.drawParameters(constructor.getParameters()))).row(Element.label("exceptions").style(Decoration.bold.bold()), Element.label(TypeRenderUtils.drawExceptions(constructor.getExceptions()))).row(Element.label("classLoaderHash").style(Decoration.bold.bold()), Element.label(constructor.getClassLoaderHash()));
        return table;
    }

    public static String[] getClassNameList(Class[] classes) {
        ArrayList<String> list = new ArrayList<String>();
        for (Class anInterface : classes) {
            list.add(StringUtils.classname(anInterface));
        }
        return list.toArray(new String[0]);
    }

    public static List<ClassVO> createClassVOList(Collection<Class<?>> matchedClasses) {
        ArrayList<ClassVO> classVOs = new ArrayList<ClassVO>(matchedClasses.size());
        for (Class<?> aClass : matchedClasses) {
            ClassVO classVO = ClassUtils.createSimpleClassInfo(aClass);
            classVOs.add(classVO);
        }
        return classVOs;
    }

    public static ClassLoaderVO createClassLoaderVO(ClassLoader classLoader) {
        ClassLoaderVO classLoaderVO = new ClassLoaderVO();
        classLoaderVO.setHash(ClassUtils.classLoaderHash(classLoader));
        classLoaderVO.setName(classLoader == null ? "BootstrapClassLoader" : classLoader.toString());
        ClassLoader parent = classLoader == null ? null : classLoader.getParent();
        classLoaderVO.setParent(parent == null ? null : parent.toString());
        return classLoaderVO;
    }

    public static List<ClassLoaderVO> createClassLoaderVOList(Collection<ClassLoader> classLoaders) {
        ArrayList<ClassLoaderVO> classLoaderVOList = new ArrayList<ClassLoaderVO>();
        for (ClassLoader classLoader : classLoaders) {
            classLoaderVOList.add(ClassUtils.createClassLoaderVO(classLoader));
        }
        return classLoaderVOList;
    }

    public static String classLoaderHash(Class<?> clazz) {
        if (clazz == null || clazz.getClassLoader() == null) {
            return "null";
        }
        return Integer.toHexString(clazz.getClassLoader().hashCode());
    }

    public static String classLoaderHash(ClassLoader classLoader) {
        if (classLoader == null) {
            return "null";
        }
        return Integer.toHexString(classLoader.hashCode());
    }

    public static Element renderMatchedClasses(Collection<ClassVO> matchedClasses) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new LabelElement("NAME").style(Decoration.bold.bold()), new LabelElement("HASHCODE").style(Decoration.bold.bold()), new LabelElement("CLASSLOADER").style(Decoration.bold.bold()));
        for (ClassVO c : matchedClasses) {
            table.row(Element.label(c.getName()), Element.label(c.getClassLoaderHash()).style(Decoration.bold.fg(Color.red)), TypeRenderUtils.drawClassLoader(c));
        }
        return table;
    }
}

