package com.ruoyi.system.service.zb;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.system.domain.zb.ZbReportRecord;
import com.ruoyi.system.domain.zb.vo.ReportFinishedItem;
import com.ruoyi.system.domain.zb.vo.ReportRecordAppDetail;
import com.ruoyi.system.domain.zb.vo.ReportRecordItem;
import com.ruoyi.system.domain.zb.vo.ReportRecordWithDepItem;

import java.util.List;

/**
 * * Author: brenda
 * * 2025/1/10
 **/
public interface ReportRecordService {

    /**
     * 周报填写个数
     * @param reportId
     * @return
     */
    int getReportFilledCount(String reportId, List<String> userIds);

    /**
     * 完成情况，返回名字
     * @param reportId
     * @return
     */
    ReportFinishedItem finishCondition(String reportId, String userId);

    List<ReportRecordItem> getFinishedUser(String reportId, List<String> userIds);

    PageInfo<ReportRecordItem> pageFinishedUser(String reportId, List<String> userIds);

    void save(ZbReportRecord zbReportRecord);

    /**
     * 周报完成情况包括未完成的列表(APP)
     * @param reportId
     * @return
     */
    List<ReportRecordWithDepItem> weekReportDetail(String reportId, String userId);

    /**
     * app, 是否能修改填写等权限
     * @param user
     * @param reportId
     * @return
     */
    ReportRecordAppDetail appReportDetail(SysUser user, String reportId);
}
