package com.ruoyi.system.service.grid.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.ruoyi.system.domain.grid.GridWgLog;
import com.ruoyi.system.domain.grid.GridWgLogExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridWgLogMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridWgLogService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridWgLogService实现
 */
@Service
@MyBaseService
public class GridWgLogServiceImpl extends BaseServiceImpl<GridWgLogMapper, GridWgLog, GridWgLogExample> implements GridWgLogService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridWgLogServiceImpl.class);

    @Autowired
    GridWgLogMapper wsWgLogMapper;

    @Override
    public Map<String, Object> infoAll(String wgCode, String startTime, String endTime) {
        return wsWgLogMapper.selectInfo(wgCode, startTime, endTime);
    }

    @Override
    public List<GridWgLog> infoPage(String objectId, String type, String operate, String startTime, String endTime) {
        GridWgLogExample ex = new GridWgLogExample();
        GridWgLogExample.Criteria ca = ex.createCriteria();
        if (StringUtils.isNotBlank(type)) {
            ca.andTypeEqualTo(type);
        }
        if (StringUtils.isNotBlank(objectId)) {
            ca.andObjectIdEqualTo(objectId);
        }
        if (StringUtils.isNotBlank(operate)) {
            ca.andOperateEqualTo(operate);
        }
        if (StringUtils.isNotBlank(startTime) && StringUtils.isNotBlank(endTime)) {
            ca.andCreateTimeBetween(startTime, endTime);
        }
        ex.setOrderByClause(" create_time desc, create_name ");
        return this.selectByExample(ex);
    }

    @Override
    @Transactional
    public void add(GridWgLog wsWgLog) {
        wsWgLog.setId(IdUtil.fastSimpleUUID());
        wsWgLog.setCreateTime(DateUtil.formatDate(new Date()));
        this.insertSelective(wsWgLog);
    }
}
