package com.ruoyi.system.service.grid.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.system.domain.grid.GridPendingPeople;
import com.ruoyi.system.domain.grid.GridPendingPeopleExample;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.grid.ext.GridPendingPeopleExt;
import com.ruoyi.system.domain.md.request.NewMsgSendRequest;
import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridPendingPeopleMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridPendingPeopleService;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.system.service.grid.GridRegionUserService;
import com.ruoyi.system.service.md.NewMsgService;
import com.ruoyi.system.service.other.BsCommonService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridPendingPeopleService实现
 */
@Service
@MyBaseService
public class GridPendingPeopleServiceImpl extends BaseServiceImpl<GridPendingPeopleMapper, GridPendingPeople, GridPendingPeopleExample> implements GridPendingPeopleService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridPendingPeopleServiceImpl.class);

    @Autowired
    GridPendingPeopleMapper gridPendingPeopleMapper;
    @Autowired
    BsCommonService bsCommonService;
    @Autowired
    GridRegionService gridRegionService;
    @Autowired
    GridRegionUserService gridRegionUserService;

    @Autowired
    private NewMsgService newMsgService;

    @Value("${app.msg.pcUrl}")
    private static String gridPcUrl;

    @Value("${app.msg.appUrl}")
    private static String gridAppUrl;

    @Value("${ws.msg.fromUserId}")
    private static String fromUserId;


    @Override
    public GridPendingPeopleExt selectGridPendingPeopleExt(GridPendingPeopleExt wsPendingPeopleExt) {

        Map<String, String> regionMap = gridRegionService.getGridRegionMap().stream().collect(Collectors.toMap(GridRegion::getWgCode, GridRegion::getWgName));
        Map<String, String> commonMap = bsCommonService.getBsCommonMap().stream().collect(Collectors.toMap(BsCommon::getCode, BsCommon::getName));

        if (StringUtils.isNotBlank(wsPendingPeopleExt.getMzCode())) {
            wsPendingPeopleExt.setMzValue(commonMap.get(wsPendingPeopleExt.getMzCode()));
        }

        if (StringUtils.isNotBlank(wsPendingPeopleExt.getHyzkCode())) {
            wsPendingPeopleExt.setHyzkValue(commonMap.get(wsPendingPeopleExt.getHyzkCode()));
        }

        if (StringUtils.isNotBlank(wsPendingPeopleExt.getWhcdCode())) {
            wsPendingPeopleExt.setWhcdValue(commonMap.get(wsPendingPeopleExt.getWhcdCode()));
        }

        if (StringUtils.isNotBlank(wsPendingPeopleExt.getZzmmCode())) {
            wsPendingPeopleExt.setZzmmValue(commonMap.get(wsPendingPeopleExt.getZzmmCode()));
        }

        if (StringUtils.isNotBlank(wsPendingPeopleExt.getWgCode())) {
            wsPendingPeopleExt.setWgValue(regionMap.get(wsPendingPeopleExt.getWgCode()));
        }

        if (StringUtils.isNotBlank(wsPendingPeopleExt.getRklxCode())) {
            wsPendingPeopleExt.setRklxValue(commonMap.get(wsPendingPeopleExt.getRklxCode()));
        }

        if (StringUtils.isNotBlank(wsPendingPeopleExt.getRkbqCode())) {
            String[] rkbqArr = wsPendingPeopleExt.getRkbqCode().split(",");
            List<String> rkbqList = new ArrayList<>();
            for (String rkbq : rkbqArr) {
                rkbqList.add(commonMap.get(rkbq));
            }
            wsPendingPeopleExt.setRkbqValue(StringUtils.join(rkbqList.toArray(), ","));
        }
        return wsPendingPeopleExt;
    }

    @Override
    @Async
    public void sendMessage(String personName, String wgCode) {
        JSONObject sendDataJson = new JSONObject();
        JSONObject paramsJson = new JSONObject();
        String title = "你有一个新的人口（" + personName + "）待认领";
//        sendDataJson.put("appid", clientId);
//        sendDataJson.put("appname", "任务中心");
        sendDataJson.put("title", title);
        sendDataJson.put("body", title);
//        sendDataJson.put("extMap", "");
        sendDataJson.put("msgtype", "0");
        sendDataJson.put("needpush", "1");
        paramsJson.put("sender", "系统管理员");
        paramsJson.put("recipient", "");
        paramsJson.put("hasatt", "0");
        paramsJson.put("attfiles", "");
        paramsJson.put("msgcategory", "通知公告");
        paramsJson.put("msglevel", "普通");
        paramsJson.put("needreply", 0);
        paramsJson.put("needsms", 0);
        paramsJson.put("redirect_pc", gridPcUrl + "/gridManage/gridObjManage/peopleInfo");
        paramsJson.put("redirect_app", gridAppUrl + "/people");
        sendDataJson.put("params", paramsJson);

        //userfrom信息
        Map<String, Object> userfromMap = new HashMap<>();
        userfromMap.put("userid", fromUserId);
        // userfromMap.put("orgid", fromUserBaseId);
        userfromMap.put("usertype", 1);
        userfromMap.put("deptid", "");

        List<Map<String, Object>> list = new ArrayList<>();
        List<GridRegionUser> bsUserList = gridRegionUserService.selectUsers(wgCode);
        if (CollectionUtils.isNotEmpty(bsUserList)) {
            for (GridRegionUser user : bsUserList) {
                Map<String, Object> toMap = new HashMap<>();
                toMap.put("userid", user.getUserId());
                toMap.put("usertype", 1);
                toMap.put("deptid", "");
                list.add(toMap);
            }
            JSONObject obj = new JSONObject();
            obj.put("sendData", sendDataJson);
            obj.put("from", userfromMap);
            obj.put("to", list);
            newMsgService.send(JSONObject.parseObject(obj.toJSONString(), NewMsgSendRequest.class));
        }
    }
}
