package com.ruoyi.system.service.grid.impl;

import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.system.domain.grid.GridHouse;
import com.ruoyi.system.domain.grid.GridHousePeople;
import com.ruoyi.system.domain.grid.GridHousePeopleExample;
import com.ruoyi.system.domain.grid.GridPeople;
import com.ruoyi.system.domain.grid.ext.GridHouseExt;
import com.ruoyi.system.domain.grid.ext.GridHousePeopleExt;
import com.ruoyi.system.domain.grid.ext.GridPeopleExt;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridHousePeopleMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridHousePeopleService;
import com.ruoyi.system.service.grid.GridHouseService;
import com.ruoyi.system.service.grid.GridPeopleService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridHousePeopleService实现
 */
@Service
@MyBaseService
public class GridHousePeopleServiceImpl extends BaseServiceImpl<GridHousePeopleMapper, GridHousePeople, GridHousePeopleExample> implements GridHousePeopleService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridHousePeopleServiceImpl.class);

    @Autowired
    GridHousePeopleMapper gridHousePeopleMapper;
    @Autowired
    private GridPeopleService gridPeopleService;
    @Autowired
    private GridHouseService gridHouseService;
    @Autowired
    GridHousePeopleService gridHousePeopleService;

    @Override
    public List<GridHousePeople> selectGridHousePeopleByHouseId(String houseId, String peopleId) {
        GridHousePeopleExample ex = new GridHousePeopleExample();
        GridHousePeopleExample.Criteria ca = ex.createCriteria();
        if (StringUtils.isNotBlank(houseId)) {
            ca.andHouseIdEqualTo(houseId);
        }
        if (StringUtils.isNotBlank(peopleId)) {
            ca.andPeopleIdEqualTo(peopleId);
        }
        ex.setOrderByClause(" create_time desc ");
        List<GridHousePeople> housePeopleList = gridHousePeopleService.selectByExample(ex);
        return housePeopleList;
    }

    @Override
    public GridHousePeopleExt selectGridHousePeopleExt(Map<String, String> wgxxbMap, Map<String, String> commonMap, GridHousePeopleExt wsHousePeopleExt, Boolean houseFlag, Boolean peopleFlag) {
        if (houseFlag) {
            GridHouse wsHouse = gridHouseService.selectByPrimaryKey(wsHousePeopleExt.getHouseId());
            GridHouseExt wsHouseExt = BeanCopyUtil.toBean(wsHouse, GridHouseExt.class);
            if (wsHouseExt != null) {
                gridHouseService.dealGridHouseExt(wgxxbMap, commonMap, wsHouseExt);
                wsHousePeopleExt.setGridHouseExt(wsHouseExt);
            }
        }
        if (peopleFlag) {
            GridPeople wsPeople = gridPeopleService.selectByPrimaryKey(wsHousePeopleExt.getPeopleId());
            GridPeopleExt wsPeopleExt = BeanCopyUtil.toBean(wsPeople, GridPeopleExt.class);
            if (wsPeopleExt != null) {
                gridPeopleService.dealPeopleExt(wgxxbMap, commonMap, wsPeopleExt);
                wsHousePeopleExt.setGridPeopleExt(wsPeopleExt);
            }
        }
        return wsHousePeopleExt;
    }

}
