package com.ruoyi.system.domain.video.ext;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class VideoPageRes {

    /** 分页数据 */
    private PageVO data;

    @Data
    public static class PageVO{
        /** 当前页码 */
        private Integer currentPage;
        /** 总页数 */
        private Integer totalPage;
        /** 页面大小 */
        private Integer pageSize;
        /** 总数 */
        private Integer totalRows;
        /** 数据列表 */
        private List<Info> pageData = new ArrayList<Info>();

        @Data
        public static class Info{
            /** 自增ID */
            private Long id;
            /** 设备编码 */
            private String deviceCode;

            private String url;

            private String imgUrl;

            /** 单元序号 */
            private Integer unitSeq;
            /** 通道序号 */
            private Integer channelSeq;
            /** 通道编码 */
            private String channelCode;
            /** 通道标识码 */
            private String channelSn;
            /** 通道名称 */
            private String channelName;
            /** 通道类型 */
            private String channelType;
            /** 所属组织编码 */
            private String ownerCode;
        }
    }
}
