package com.ruoyi.system.domain.operatingmanage;

import com.ruoyi.system.domain.publicservice.PublicServiceBaseEntity;
import com.ruoyi.system.domain.publicservice.TOtherappAttachment;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;


/**
 * 新闻表
 * @author wujm<wujm@eazytec.com>
 */
public class TOperatingmanageNews extends PublicServiceBaseEntity {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * 新闻ID
	 */
	@NotNull(message = "新闻ID")
	private Long newsId;
	
	/**
	 * 新闻标题
	 */
	@NotBlank(message = "新闻标题不能为空")
	private String newsTitle;
	
	/**
	 * 新闻类型
	 */
	@NotBlank(message = "新闻类型不能为空")
	private String newsType;
	
	/**
	 * 新闻内容
	 */
	@NotBlank(message = "新闻内容不能为空")
	private String newsContent;

	/**
	 * 是否新的新闻
	 */
	private int newFlag;

	/**
	 * 封面附件
	 */
	private List<TOtherappAttachment> attachment;
	

	public TOperatingmanageNews() {
		super();
	}

    /**
     * setter for newsId
     * @param newsId
     */
	public void setNewsId(Long newsId) {
		this.newsId = newsId;
	}

    /**
     * getter for newsId
     */
	public Long getNewsId() {
		return newsId;
	}
	
    /**
     * setter for newsTitle
     * @param newsTitle
     */
	public void setNewsTitle(String newsTitle) {
		this.newsTitle = newsTitle;
	}

    /**
     * getter for newsTitle
     */
	public String getNewsTitle() {
		return newsTitle;
	}
	
    /**
     * setter for newsType
     * @param newsType
     */
	public void setNewsType(String newsType) {
		this.newsType = newsType;
	}

    /**
     * getter for newsType
     */
	public String getNewsType() {
		return newsType;
	}
	
    /**
     * setter for newsContent
     * @param newsContent
     */
	public void setNewsContent(String newsContent) {
		this.newsContent = newsContent;
	}

    /**
     * getter for newsContent
     */
	public String getNewsContent() {
		return newsContent;
	}

	public List<TOtherappAttachment> getAttachment() {
		return attachment;
	}

	public void setAttachment(List<TOtherappAttachment> attachment) {
		this.attachment = attachment;
	}

	public int getNewFlag() {
		return newFlag;
	}

	public void setNewFlag(int newFlag) {
		this.newFlag = newFlag;
	}
}
