package com.ruoyi.system.domain.md.request;

import com.alibaba.fastjson2.JSONObject;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Setter
public class NewMsgSendData implements Serializable{

    /**
     *发件ID
     */
    @Getter
    private String outboxid;

    /**
     * 来源发件ID
     */
    @Getter
    private String orginid;

    /**
     * 消息分类(0-应用消息，10-订阅)
     */
    @Getter
    private Byte msgtype;

    /**
     * 是否推送手机端(0-否，1-是)
     */
    @Getter
    private Byte needpush;

    /**
     * 标题
     */
    @Getter
    private String title;

    /**
     * 附加参数(json)
     */
    @Getter
    private Map<String,Object> extMap;

    private String extMapJson;

    /**
     * 正文（富文本）
     */
    @Getter
    private String body;

    /**
     * 参数(json)
     params:{
         signature:签名
         sender : 发件人描述
         recipient: 收件人json{'company':[],'contact':[]}
         hasatt: 是否有附件(0-否，1-是)
         attfiles: 附件列表 (json [file:{name:'',path:''}])
         msglevel: 消息级别（紧急，重要，普通）
         msgcategory: 消息类别
         needsms： 是否短信通知(0-否，1-是)
         needreply：是否回复(0-否，1-是)
         cron : 定时表达式
         cron_st 开始日期(定时任务)	 yyyy-MM-dd
         cron_ed  结束日期(定时任务)	yyyy-MM-dd
         needrepeat : 是否循环(0-否，1-是)
         permission_user: [id,id]
         permission_org: [id,id]
         permission_dept: [id,id]
         redirect_pc   pc跳转地址
         redirect_app   移动端app跳转地址
     }
     *
     */
    @Getter
    private JSONObject params;

    private String paramsJson;

    public NewMsgSendData addExt(String key,Object value){
        if(value != null){
            if(extMap == null){
                extMap = new HashMap<>();
            }
            extMap.put(key,value);
        }
        return this;
    }

    public NewMsgSendData addParam(String key,Object value){
        if(value != null){
            if(params == null){
                params = new JSONObject();
            }
            params.put(key,value);
        }
        return this;
    }


    public String getParam(String key){
        if(params == null || !params.containsKey(key)){
            return "";
        }

        return params.get(key).toString();
    }

    public String getExtMapJson() {
        if(extMapJson == null){
            initExtMapJson();
        }
        return extMapJson;
    }

    private synchronized void initExtMapJson(){
        if(CollectionUtils.isEmpty(extMap)){
            extMapJson = "";
        }else{
            extMapJson = JSONObject.toJSONString(extMap);
        }
    }

    public String getParamsJson() {
        if(paramsJson == null){
            initParamsJson();
        }
        return paramsJson;
    }

    private synchronized void initParamsJson(){
        if(CollectionUtils.isEmpty(params)){
            paramsJson = "";
        }else{
            paramsJson = JSONObject.toJSONString(params);
        }
    }

}
