package com.ruoyi.party.service.api;

import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.party.domain.PartyOrganization;
import com.ruoyi.party.domain.vo.PartyOrganizationVo;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;

import java.util.List;
import java.util.Map;

/**
 * 党组织管理Service接口
 *
 * @author ruoyi
 * @date 2024-05-17
 */
public interface IPartyOrganizationService
{
    /**
     * 查询党组织管理
     *
     * @param id 党组织管理主键
     * @return 党组织管理
     */
    public PartyOrganizationVo selectPartyOrganizationById(String id);

    /**
     * 查询党组织管理列表
     *
     * @param partyOrganization 党组织管理
     * @return 党组织管理集合
     */
    public List<PartyOrganization> selectPartyOrganizationList(PartyOrganization partyOrganization);

    /**
     * 新增党组织管理
     *
     * @param partyOrganization 党组织管理
     * @return 结果
     */
    public int insertPartyOrganization(PartyOrganization partyOrganization);

    /**
     * 修改党组织管理
     *
     * @param partyOrganization 党组织管理
     * @return 结果
     */
    public int updatePartyOrganization(PartyOrganization partyOrganization);

    /**
     * 批量删除党组织管理
     *
     * @param ids 需要删除的党组织管理主键集合
     * @return 结果
     */
    public int deletePartyOrganizationByIds(String[] ids);

    /**
     * 删除党组织管理信息
     *
     * @param id 党组织管理主键
     * @return 结果
     */
    public int deletePartyOrganizationById(String id);

    public int countOrg();

    public List<Map<String,String>> getPartyOrgBuild(List<SysDictData> dictDataList);

    List<PartyOrganizationVo> partyOrganizationTree(PartyOrganization partyOrganization);

    void importExcel(Workbook workbook, List<SysDictData> partyTypeList, List<SysDictData> sdgxList);

    HSSFWorkbook exportTemplate();

    /**
     * 根据党组织代码查找党组织
     * @param dzzdm
     * @return
     */
    PartyOrganization getByDzzdm(String dzzdm);

    /**
     * 根据名字查找党组织
     * @param dzzmc
     * @return
     */
    PartyOrganization getByDzzmc(String dzzmc);
}
