package com.ruoyi.party.mapper;

import com.ruoyi.party.domain.PartyOrganizationError;

import java.util.List;

/**
 * 党组织管理Mapper接口
 * 
 * @author ruoyi
 * @date 2024-05-21
 */
public interface PartyOrganizationErrorMapper 
{
    /**
     * 查询党组织管理
     * 
     * @param id 党组织管理主键
     * @return 党组织管理
     */
    public PartyOrganizationError selectPartyOrganizationErrorById(Long id);

    /**
     * 查询党组织管理列表
     * 
     * @param partyOrganizationError 党组织管理
     * @return 党组织管理集合
     */
    public List<PartyOrganizationError> selectPartyOrganizationErrorList(PartyOrganizationError partyOrganizationError);

    /**
     * 新增党组织管理
     * 
     * @param partyOrganizationError 党组织管理
     * @return 结果
     */
    public int insertPartyOrganizationError(PartyOrganizationError partyOrganizationError);

    /**
     * 修改党组织管理
     * 
     * @param partyOrganizationError 党组织管理
     * @return 结果
     */
    public int updatePartyOrganizationError(PartyOrganizationError partyOrganizationError);

    /**
     * 删除党组织管理
     * 
     * @param id 党组织管理主键
     * @return 结果
     */
    public int deletePartyOrganizationErrorById(Long id);

    /**
     * 批量删除党组织管理
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deletePartyOrganizationErrorByIds(Long[] ids);
}
