package com.ruoyi.common.utils;

//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.WeekFields;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

import org.apache.commons.lang3.StringUtils;

public final class DateUtil implements Serializable {
    public static final String FULL_SIMPLE_DATE_PATTERN = "yyyy/MM/dd HH:mm:ss";
    public static final String SHORT_SIMPLE_DATE_PATTERN = "yyyy/MM/dd";
    public static final String T_SIMPLE_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String T_SIMPLE_DATE = "yyyy-MM-dd";

    public static final String T_TIME = "HH:mm:ss";
    private static final long serialVersionUID = -3098985139095632110L;
    public static final String DATAFORMAT_STR = "yyyy-MM-dd";
    public static final String YYYY_MM_DATAFORMAT_STR = "yyyy-MM";
    public static final String DATATIMEF_STR = "yyyy-MM-dd HH:mm:ss";
    public static final String DATATIMEF_P_STR = "yyyyMMddHHmmss";
    public static final String ZHCN_DATAFORMAT_STR = "yyyy年MM月dd日";
    public static final String ZHCN_DATATIMEF_STR = "yyyy年MM月dd日HH时mm分ss秒";
    public static final String ZHCN_DATATIMEF_STR_4yMMddHHmm = "yyyy年MM月dd日HH时mm分";

    public static String dateFormat(String sdate, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = Date.valueOf(sdate);
        String dateString = formatter.format(date);
        return dateString;
    }

    public static long getIntervalDays(String sd, String ed) {
        return (Date.valueOf(ed).getTime() - Date.valueOf(sd).getTime()) / 86400000L;
    }

    public static int getInterval(String beginMonth, String endMonth) {
        int intBeginYear = Integer.parseInt(beginMonth.substring(0, 4));
        int intBeginMonth = Integer.parseInt(beginMonth.substring(beginMonth.indexOf("-") + 1));
        int intEndYear = Integer.parseInt(endMonth.substring(0, 4));
        int intEndMonth = Integer.parseInt(endMonth.substring(endMonth.indexOf("-") + 1));
        return (intEndYear - intBeginYear) * 12 + (intEndMonth - intBeginMonth) + 1;
    }

    public static java.util.Date getDate(String sDate, String dateFormat) {
        SimpleDateFormat fmt = new SimpleDateFormat(dateFormat);
        ParsePosition pos = new ParsePosition(0);
        return fmt.parse(sDate, pos);
    }

    public static String getCurrentYear() {
        return getFormatCurrentTime("yyyy");
    }


    public static String getCurrentMonth() {
        return getFormatCurrentTime("MM");
    }

    public static String getCurrentDay() {
        return getFormatCurrentTime("dd");
    }

    public static String getCurrentHour() {
        return getFormatCurrentTime("HH");
    }

    public static String getCurrentDateExecptMs() {
        return getFormatCurrentTime("yyyy-MM-dd HH");
    }

    public static String getCurrentMinute() {
        return getFormatCurrentTime("mm");
    }

    public static String getCurrentDate() {
        return getFormatDateTime(new java.util.Date(), "yyyy-MM-dd");
    }

    public static String getCurrentDateTime() {
        return getFormatDateTime(new java.util.Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatDate(java.util.Date date) {
        return getFormatDateTime(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatDate(java.util.Date date, String daFormat) {
        return getFormatDateTime(date, daFormat);
    }

    public static String getFormatDate(String format) {
        return getFormatDateTime(new java.util.Date(), format);
    }

    public static String getCurrentTime() {
        return getFormatDateTime(new java.util.Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentTimeForType(String dateType) {
        return getFormatDateTime(new java.util.Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatTime(java.util.Date date) {
        return getFormatDateTime(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatCurrentTime(String format) {
        return getFormatDateTime(new java.util.Date(), format);
    }

    public static String getFormatDateTime(java.util.Date date, String format) {
        if (date == null) {
            return null;
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(date);
        }
    }

    public static java.util.Date getDateObj(int year, int month, int day) {
        Calendar c = new GregorianCalendar();
        c.set(year, month - 1, day);
        return c.getTime();
    }

    public static String getDateTomorrow(String date) {
        java.util.Date tempDate = null;
        if (date.indexOf("/") > 0) {
            tempDate = getDateObj(date, "[/]");
        }

        if (date.indexOf("-") > 0) {
            tempDate = getDateObj(date, "[-]");
        }

        tempDate = getDateAdd(tempDate, 1);
        return getFormatDateTime(tempDate, "yyyy/MM/dd");
    }

    public static String getDateTomorrow2(String date) {
        java.util.Date tempDate = null;
        if (date.indexOf("/") > 0) {
            tempDate = getDateObj(date, "[/]");
        }

        if (date.indexOf("-") > 0) {
            tempDate = getDateObj(date, "[-]");
        }

        tempDate = getDateAdd(tempDate, 1);
        return getFormatDateTime(tempDate, "yyyy-MM-dd");
    }

    public static java.util.Date getDateOffset(String date, int offset) {
        java.util.Date tempDate = null;
        if (date.indexOf("/") > 0) {
            tempDate = getDateObj(date, "[/]");
        }

        if (date.indexOf("-") > 0) {
            tempDate = getDateObj(date, "[-]");
        }

        return getDateAdd(tempDate, offset);
    }

    public static java.util.Date getDateObj(String argsDate, String split) {
        String[] temp = argsDate.split(split);
        int year = new Integer(temp[0]);
        int month = new Integer(temp[1]);
        int day = new Integer(temp[2]);
        return getDateObj(year, month, day);
    }

    public static java.util.Date getDate2String(String formatStr, String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        java.util.Date resDate = null;
        if (StringUtils.isBlank(dateStr)) {
            return null;
        } else {
            try {
                resDate = sdf.parse(dateStr);
            } catch (Exception var5) {
                var5.printStackTrace();
            }

            return resDate;
        }
    }

    public static java.util.Date getDateObj() {
        Calendar c = new GregorianCalendar();
        return c.getTime();
    }

    public static int getDaysOfCurMonth() {
        int curyear = new Integer(getCurrentYear());
        int curMonth = new Integer(getCurrentMonth());
        int[] mArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (curyear % 400 == 0 || curyear % 100 != 0 && curyear % 4 == 0) {
            mArray[1] = 29;
        }

        return mArray[curMonth - 1];
    }

    public static int getDaysOfCurMonth(String time) {
        if (time.length() != 7) {
            throw new NullPointerException("参数的格式必须是yyyy-MM");
        } else {
            String[] timeArray = time.split("-");
            int curyear = new Integer(timeArray[0]);
            int curMonth = new Integer(timeArray[1]);
            if (curMonth > 12) {
                throw new NullPointerException("参数的格式必须是yyyy-MM，而且月份必须小于等于12。");
            } else {
                int[] mArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
                if (curyear % 400 == 0 || curyear % 100 != 0 && curyear % 4 == 0) {
                    mArray[1] = 29;
                }

                return curMonth == 12 ? mArray[0] : mArray[curMonth - 1];
            }
        }
    }

    public static int getDayofWeekInMonth(String year, String month, String weekOfMonth, String dayOfWeek) {
        Calendar cal = new GregorianCalendar();
        int y = new Integer(year);
        int m = new Integer(month);
        cal.clear();
        cal.set(y, m - 1, 1);
        cal.set(8, new Integer(weekOfMonth));
        cal.set(7, new Integer(dayOfWeek));
        return cal.get(5);
    }

    public static java.util.Date getDate(int year, int month, int date, int hourOfDay, int minute, int second) {
        Calendar cal = new GregorianCalendar();
        cal.set(year, month, date, hourOfDay, minute, second);
        return cal.getTime();
    }

    public static int getDayOfWeek(String year, String month, String day) {
        Calendar cal = new GregorianCalendar(new Integer(year), new Integer(month) - 1, new Integer(day));
        return cal.get(7);
    }

    public static int getDayOfWeek(String date) {
        String[] temp = null;
        if (date.indexOf("/") > 0) {
            temp = date.split("/");
        }

        if (date.indexOf("-") > 0) {
            temp = date.split("-");
        }

        return getDayOfWeek(temp[0], temp[1], temp[2]);
    }

    public static String getChinaDayOfWeek(String date) {
        String[] weeks = new String[]{"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};
        int week = getDayOfWeek(date);
        return weeks[week - 1];
    }

    public static int getDayOfWeek(java.util.Date date) {
        Calendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getWeekOfYear(String year, String month, String day) {
        Calendar cal = new GregorianCalendar();
        cal.clear();
        cal.set(new Integer(year), new Integer(month) - 1, new Integer(day));
        return cal.get(3);
    }

    public static java.util.Date getDateAdd(java.util.Date date, int amount) {
        Calendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(5, amount);
        return cal.getTime();
    }

    public static String getFormatDateAdd(java.util.Date date, int amount, String format) {
        Calendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(5, amount);
        return getFormatDateTime(cal.getTime(), format);
    }

    public static String getFormatCurrentAdd(int amount, String format) {
        java.util.Date d = getDateAdd(new java.util.Date(), amount);
        return getFormatDateTime(d, format);
    }

    public static String getFormatYestoday(String format) {
        return getFormatCurrentAdd(-1, format);
    }

    public static String getYestoday(String sourceDate, String format) {
        return getFormatDateAdd(getDate2String(sourceDate, format), -1, format);
    }

    public static String getFormatTomorrow(String format) {
        return getFormatCurrentAdd(1, format);
    }

    public static String getFormatDateTommorrow(String sourceDate, String format) {
        return getFormatDateAdd(getDate2String(sourceDate, format), 1, format);
    }

    public static String getCurrentDateString(String dateFormat) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(cal.getTime());
    }

    public static String getCurTimeByFormat(String format) {
        java.util.Date newdate = new java.util.Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(newdate);
    }

    public static long getDiffSeconds(String startTime, String endTime) {
        long diff = 0L;
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        try {
            java.util.Date startDate = ft.parse(startTime);
            java.util.Date endDate = ft.parse(endTime);
            diff = startDate.getTime() - endDate.getTime();
            diff /= 1000L;
        } catch (ParseException var7) {
            var7.printStackTrace();
        }

        return diff;
    }

    public static String getHour(long second) {
        long hour = second / 60L / 60L;
        long minute = (second - hour * 60L * 60L) / 60L;
        long sec = second - hour * 60L * 60L - minute * 60L;
        return hour + "小时" + minute + "分钟" + sec + "秒";
    }

    public static String getDateTime(long microsecond) {
        return getFormatDateTime(new java.util.Date(microsecond), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateByAddFltHour(float flt) {
        int addMinute = (int) (flt * 60.0F);
        Calendar cal = new GregorianCalendar();
        cal.setTime(new java.util.Date());
        cal.add(12, addMinute);
        return getFormatDateTime(cal.getTime(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateByAddHour(String datetime, int minute) {
        String returnTime = null;
        Calendar cal = new GregorianCalendar();
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        try {
            java.util.Date date = ft.parse(datetime);
            cal.setTime(date);
            cal.add(12, minute);
            returnTime = getFormatDateTime(cal.getTime(), "yyyy-MM-dd HH:mm:ss");
        } catch (ParseException var7) {
            var7.printStackTrace();
        }

        return returnTime;
    }

    public static int getDiffHour(String startTime, String endTime) {
        long diff = 0L;
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        try {
            java.util.Date startDate = ft.parse(startTime);
            java.util.Date endDate = ft.parse(endTime);
            diff = startDate.getTime() - endDate.getTime();
            diff /= 3600000L;
        } catch (ParseException var7) {
            var7.printStackTrace();
        }

        return (new Long(diff)).intValue();
    }

    public static int getDiffHour(String startTime, String endTime, String dateFormat) {
        long diff = 0L;
        SimpleDateFormat ft = new SimpleDateFormat(dateFormat);

        try {
            java.util.Date startDate = ft.parse(startTime);
            java.util.Date endDate = ft.parse(endTime);
            diff = startDate.getTime() - endDate.getTime();
            diff /= 3600000L;
        } catch (ParseException var8) {
            var8.printStackTrace();
        }

        return (new Long(diff)).intValue();
    }

    public static String getYearSelect(String selectName, String value, int startYear, int endYear) {
        int start = startYear;
        int end = endYear;
        if (startYear > endYear) {
            start = endYear;
            end = startYear;
        }

        StringBuffer sb = new StringBuffer("");
        sb.append("<select name=\"" + selectName + "\">");

        for (int i = start; i <= end; ++i) {
            if (!"".equals(value.trim()) && i == Integer.parseInt(value)) {
                sb.append("<option value=\"" + i + "\" selected>" + i + "</option>");
            } else {
                sb.append("<option value=\"" + i + "\">" + i + "</option>");
            }
        }

        sb.append("</select>");
        return sb.toString();
    }

    public static String getYearSelect(String selectName, String value, int startYear, int endYear, boolean hasBlank) {
        int start = startYear;
        int end = endYear;
        if (startYear > endYear) {
            start = endYear;
            end = startYear;
        }

        StringBuffer sb = new StringBuffer("");
        sb.append("<select name=\"" + selectName + "\">");
        if (hasBlank) {
            sb.append("<option value=\"\"></option>");
        }

        for (int i = start; i <= end; ++i) {
            if (!"".equals(value.trim()) && i == Integer.parseInt(value)) {
                sb.append("<option value=\"" + i + "\" selected>" + i + "</option>");
            } else {
                sb.append("<option value=\"" + i + "\">" + i + "</option>");
            }
        }

        sb.append("</select>");
        return sb.toString();
    }

    public static String getYearSelect(String selectName, String value, int startYear, int endYear, boolean hasBlank, String js) {
        int start = startYear;
        int end = endYear;
        if (startYear > endYear) {
            start = endYear;
            end = startYear;
        }

        StringBuffer sb = new StringBuffer("");
        sb.append("<select name=\"" + selectName + "\" " + js + ">");
        if (hasBlank) {
            sb.append("<option value=\"\"></option>");
        }

        for (int i = start; i <= end; ++i) {
            if (!"".equals(value.trim()) && i == Integer.parseInt(value)) {
                sb.append("<option value=\"" + i + "\" selected>" + i + "</option>");
            } else {
                sb.append("<option value=\"" + i + "\">" + i + "</option>");
            }
        }

        sb.append("</select>");
        return sb.toString();
    }

    public static String getYearSelect(String selectName, String value, int startYear, int endYear, String js) {
        int start = startYear;
        int end = endYear;
        if (startYear > endYear) {
            start = endYear;
            end = startYear;
        }

        StringBuffer sb = new StringBuffer("");
        sb.append("<select name=\"" + selectName + "\" " + js + ">");

        for (int i = start; i <= end; ++i) {
            if (!"".equals(value.trim()) && i == Integer.parseInt(value)) {
                sb.append("<option value=\"" + i + "\" selected>" + i + "</option>");
            } else {
                sb.append("<option value=\"" + i + "\">" + i + "</option>");
            }
        }

        sb.append("</select>");
        return sb.toString();
    }

    public static String getMonthSelect(String selectName, String value, boolean hasBlank) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<select name=\"" + selectName + "\">");
        if (hasBlank) {
            sb.append("<option value=\"\"></option>");
        }

        for (int i = 1; i <= 12; ++i) {
            if (!"".equals(value.trim()) && i == Integer.parseInt(value)) {
                sb.append("<option value=\"" + i + "\" selected>" + i + "</option>");
            } else {
                sb.append("<option value=\"" + i + "\">" + i + "</option>");
            }
        }

        sb.append("</select>");
        return sb.toString();
    }

    public static String getMonthSelect(String selectName, String value, boolean hasBlank, String js) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<select name=\"" + selectName + "\" " + js + ">");
        if (hasBlank) {
            sb.append("<option value=\"\"></option>");
        }

        for (int i = 1; i <= 12; ++i) {
            if (!"".equals(value.trim()) && i == Integer.parseInt(value)) {
                sb.append("<option value=\"" + i + "\" selected>" + i + "</option>");
            } else {
                sb.append("<option value=\"" + i + "\">" + i + "</option>");
            }
        }

        sb.append("</select>");
        return sb.toString();
    }

    public static String getDaySelect(String selectName, String value, boolean hasBlank) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<select name=\"" + selectName + "\">");
        if (hasBlank) {
            sb.append("<option value=\"\"></option>");
        }

        for (int i = 1; i <= 31; ++i) {
            if (!"".equals(value.trim()) && i == Integer.parseInt(value)) {
                sb.append("<option value=\"" + i + "\" selected>" + i + "</option>");
            } else {
                sb.append("<option value=\"" + i + "\">" + i + "</option>");
            }
        }

        sb.append("</select>");
        return sb.toString();
    }

    public static String getDaySelect(String selectName, String value, boolean hasBlank, String js) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<select name=\"" + selectName + "\" " + js + ">");
        if (hasBlank) {
            sb.append("<option value=\"\"></option>");
        }

        for (int i = 1; i <= 31; ++i) {
            if (!"".equals(value.trim()) && i == Integer.parseInt(value)) {
                sb.append("<option value=\"" + i + "\" selected>" + i + "</option>");
            } else {
                sb.append("<option value=\"" + i + "\">" + i + "</option>");
            }
        }

        sb.append("</select>");
        return sb.toString();
    }

    /**
     * 获取当前季度
     *
     * @return
     */
    public static Integer getCurrentQuarter() {
        Calendar cal = Calendar.getInstance();
        int m = cal.get(Calendar.MONTH) + 1;
        int quarter = 1;
        if (m >= 1 && m == 3) {
            quarter = 1;
        }
        if (m >= 4 && m <= 6) {
            quarter = 2;
        }
        if (m >= 7 && m <= 9) {
            quarter = 3;
        }
        if (m >= 10 && m <= 12) {
            quarter = 4;
        }
        return quarter;
    }

    public static int getWeek() {
        String[][] strArray = {{"MONDAY", "1"}, {"TUESDAY", "2"}, {"WEDNESDAY", "3"}, {"THURSDAY", "4"}, {"FRIDAY", "5"}, {"SATURDAY", "6"}, {"SUNDAY", "7"}};
        LocalDate currentDate = LocalDate.now();
        String k = String.valueOf(currentDate.getDayOfWeek());
        int oo = 0;
        //获取行数
        for (int i = 0; i < strArray.length; i++) {
            if (k.equals(strArray[i][0])) {
                oo = Integer.parseInt(strArray[i][1]);
                break;
            }
        }
        return oo;
    }

    //获取当前周期
    public static String getCycleNow(String cycleType) {
        StringBuffer cycle = new StringBuffer();
        LocalDate localDate2 = LocalDate.now();
        int year = localDate2.getYear();
        switch (cycleType) {
            //周
            case "ww":
                WeekFields weekFields = WeekFields.of(Locale.getDefault());
                int weekNumber = LocalDate.now().get(weekFields.weekOfWeekBasedYear());
                cycle.append(year).append("ww").append(weekNumber);
                break;
            //月
            case "m":
                LocalDate localDate = LocalDate.now();
                int m = localDate.getMonthValue();
                cycle.append(year).append("m").append(m);
                break;
            //季度
            default:
                LocalDate local = LocalDate.now();
                int mm = local.getMonthValue();
                String q = "";
                if (mm >= 1 && mm == 3) {
                    q = "1";
                } else if (mm >= 4 && mm <= 6) {
                    q = "2";
                } else if (mm >= 7 && mm <= 9) {
                    q = "3";
                } else {
                    q = "4";
                }
                cycle.append(year).append("q").append(q);
                break;
        }
        return cycle.toString();
    }


    /*
     * 将时间戳转换为时间
     */
    public static String stampToDate(Long s,String fmt){
        if(StringUtils.isBlank(fmt)){
            fmt = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(fmt);
        java.util.Date date = new java.util.Date(s);
        String res = simpleDateFormat.format(date);
        return res;
    }
}
