/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http.session;

import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpRequest;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpResponse;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.cookie.Cookie;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import com.alibaba.arthas.deps.io.netty.util.Attribute;
import com.alibaba.arthas.deps.io.netty.util.AttributeKey;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSession;
import com.taobao.arthas.core.shell.term.impl.http.session.LRUCache;
import com.taobao.arthas.core.shell.term.impl.http.session.SimpleHttpSession;
import java.util.Collections;
import java.util.Set;

public class HttpSessionManager {
    public static AttributeKey<HttpSession> SESSION_KEY = AttributeKey.valueOf("session");
    private LRUCache<String, HttpSession> sessions = new LRUCache(1024);

    private HttpSession getSession(HttpRequest httpRequest) {
        String value = httpRequest.headers().get(HttpHeaderNames.COOKIE);
        Set<Object> cookies = value == null ? Collections.emptySet() : ServerCookieDecoder.STRICT.decode(value);
        for (Cookie cookie : cookies) {
            if (!"asession".equals(cookie.name())) continue;
            String sessionId = cookie.value();
            return this.sessions.get(sessionId);
        }
        return null;
    }

    public static HttpSession getHttpSessionFromContext(ChannelHandlerContext ctx) {
        return ctx.channel().attr(SESSION_KEY).get();
    }

    public HttpSession getOrCreateHttpSession(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        Attribute<HttpSession> attribute = ctx.channel().attr(SESSION_KEY);
        HttpSession httpSession = attribute.get();
        if (httpSession != null) {
            return httpSession;
        }
        httpSession = this.getSession(httpRequest);
        if (httpSession != null) {
            attribute.set(httpSession);
            return httpSession;
        }
        httpSession = this.newHttpSession();
        attribute.set(httpSession);
        return httpSession;
    }

    private HttpSession newHttpSession() {
        SimpleHttpSession session = new SimpleHttpSession();
        this.sessions.put(session.getId(), session);
        return session;
    }

    public static void setSessionCookie(HttpResponse response, HttpSession session) {
        response.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.STRICT.encode("asession", session.getId()));
    }

    public void start() {
    }

    public void stop() {
        this.sessions.clear();
    }
}

