/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.BusyThreadInfo;
import com.taobao.arthas.core.command.model.ThreadModel;
import com.taobao.arthas.core.command.model.ThreadVO;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.command.view.ViewRenderUtil;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ThreadUtil;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.util.RenderUtil;
import java.util.List;
import java.util.Map;

public class ThreadView
extends ResultView<ThreadModel> {
    @Override
    public void draw(CommandProcess process, ThreadModel result) {
        if (result.getThreadInfo() != null) {
            String content = ThreadUtil.getFullStacktrace(result.getThreadInfo());
            process.write(content);
        } else if (result.getBusyThreads() != null) {
            List<BusyThreadInfo> threadInfos = result.getBusyThreads();
            for (BusyThreadInfo info : threadInfos) {
                String stacktrace = ThreadUtil.getFullStacktrace(info, -1, -1);
                process.write(stacktrace).write("\n");
            }
        } else if (result.getBlockingLockInfo() != null) {
            String stacktrace = ThreadUtil.getFullStacktrace(result.getBlockingLockInfo());
            process.write(stacktrace);
        } else if (result.getThreadStateCount() != null) {
            int height;
            Map<Thread.State, Integer> threadStateCount = result.getThreadStateCount();
            List<ThreadVO> threadStats = result.getThreadStats();
            int total = 0;
            for (Integer n : threadStateCount.values()) {
                total += n.intValue();
            }
            int internalThreadCount = 0;
            for (ThreadVO threadVO : threadStats) {
                if (threadVO.getId() > 0L) continue;
                ++internalThreadCount;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Threads Total: ").append(total += internalThreadCount);
            for (Thread.State s : Thread.State.values()) {
                Integer count = threadStateCount.get((Object)s);
                stringBuilder.append(", ").append(s.name()).append(": ").append(count);
            }
            if (internalThreadCount > 0) {
                stringBuilder.append(", Internal threads: ").append(internalThreadCount);
            }
            String string = RenderUtil.render(new LabelElement(stringBuilder), process.width());
            if (result.isAll()) {
                height = threadStats.size() + 1;
            } else {
                height = Math.max(5, process.height() - 2);
                height = Math.min(height, threadStats.size() + 2);
            }
            String content = ViewRenderUtil.drawThreadInfo(threadStats, process.width(), height);
            process.write(string + content);
        }
    }
}

