/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListenerAdapter;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.model.TimeFragmentVO;
import com.taobao.arthas.core.command.model.TimeTunnelModel;
import com.taobao.arthas.core.command.monitor200.TimeFragment;
import com.taobao.arthas.core.command.monitor200.TimeTunnelCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import java.util.Collections;
import java.util.Date;

public class TimeTunnelAdviceListener
extends AdviceListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TimeTunnelAdviceListener.class);
    private final ThreadLocal<ObjectStack> argsRef = new ThreadLocal<ObjectStack>(){

        @Override
        protected ObjectStack initialValue() {
            return new ObjectStack(512);
        }
    };
    private TimeTunnelCommand command;
    private CommandProcess process;
    private volatile boolean isFirst = true;
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();

    public TimeTunnelAdviceListener(TimeTunnelCommand command, CommandProcess process, boolean verbose) {
        this.command = command;
        this.process = process;
        super.setVerbose(verbose);
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.argsRef.get().push(args);
        this.threadLocalWatch.start();
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        args = (Object[])this.argsRef.get().pop();
        this.afterFinishing(Advice.newForAfterRetuning(loader, clazz, method, target, args, returnObject));
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) {
        args = (Object[])this.argsRef.get().pop();
        this.afterFinishing(Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable));
    }

    private void afterFinishing(Advice advice) {
        double cost = this.threadLocalWatch.costInMillis();
        TimeFragment timeTunnel = new TimeFragment(advice, new Date(), cost);
        boolean match = false;
        try {
            match = this.isConditionMet(this.command.getConditionExpress(), advice, cost);
            if (this.isVerbose()) {
                this.process.write("Condition express: " + this.command.getConditionExpress() + " , result: " + match + "\n");
            }
        }
        catch (ExpressException e) {
            logger.warn("tt failed.", e);
            this.process.end(-1, "tt failed, condition is: " + this.command.getConditionExpress() + ", " + e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more details.");
        }
        if (!match) {
            return;
        }
        int index = this.command.putTimeTunnel(timeTunnel);
        TimeFragmentVO timeFragmentVO = TimeTunnelCommand.createTimeFragmentVO(index, timeTunnel);
        TimeTunnelModel timeTunnelModel = new TimeTunnelModel().setTimeFragmentList(Collections.singletonList(timeFragmentVO)).setFirst(this.isFirst);
        this.process.appendResult(timeTunnelModel);
        if (this.isFirst) {
            this.isFirst = false;
        }
        this.process.times().incrementAndGet();
        if (this.isLimitExceeded(this.command.getNumberOfLimit(), this.process.times().get())) {
            this.abortProcess(this.process, this.command.getNumberOfLimit());
        }
    }

    static class ObjectStack {
        private Object[] array;
        private int pos = 0;
        private int cap;

        public ObjectStack(int maxSize) {
            this.array = new Object[maxSize];
            this.cap = this.array.length;
        }

        public int size() {
            return this.pos;
        }

        public void push(Object value) {
            if (this.pos < this.cap) {
                this.array[this.pos++] = value;
            } else {
                this.pos = 0;
                this.array[this.pos++] = value;
            }
        }

        public Object pop() {
            if (this.pos > 0) {
                --this.pos;
                Object object = this.array[this.pos];
                this.array[this.pos] = null;
                return object;
            }
            this.pos = this.cap;
            --this.pos;
            Object object = this.array[this.pos];
            this.array[this.pos] = null;
            return object;
        }
    }
}

