package com.ruoyi.party.service.impl;

import com.ruoyi.common.annotation.DataSource;
import com.ruoyi.common.enums.DataSourceType;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.party.domain.ExcellentPartyMember;
import com.ruoyi.party.domain.vo.ExcellentPartyMemberVo;
import com.ruoyi.party.mapper.ExcellentPartyMemberMapper;
import com.ruoyi.party.mapper.PartyMemberMapper;
import com.ruoyi.party.service.api.IExcellentPartyMemberService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 优秀党员Service业务层处理
 * 
 * @author ruoyi
 * @date 2024-05-27
 */
@Service
@DataSource(value = DataSourceType.SLAVE)
public class ExcellentPartyMemberServiceImpl implements IExcellentPartyMemberService
{
    @Autowired
    private ExcellentPartyMemberMapper excellentPartyMemberMapper;

    @Autowired
    private PartyMemberMapper partyMemberMapper;

    /**
     * 查询优秀党员
     * 
     * @param id 优秀党员主键
     * @return 优秀党员
     */
    @Override
    public ExcellentPartyMember selectExcellentPartyMemberById(Long id)
    {
        return excellentPartyMemberMapper.selectExcellentPartyMemberById(id);
    }

    /**
     * 查询优秀党员列表
     * 
     * @param excellentPartyMember 优秀党员
     * @return 优秀党员
     */
    @Override
    public List<ExcellentPartyMemberVo> selectExcellentPartyMemberList(ExcellentPartyMember excellentPartyMember) {
        return excellentPartyMemberMapper.selectExcellentPartyMemberVoList(excellentPartyMember);
    }

    /**
     * 新增优秀党员
     * 
     * @param excellentPartyMember 优秀党员
     * @return 结果
     */
    @Override
    public int insertExcellentPartyMember(ExcellentPartyMember excellentPartyMember)
    {
        excellentPartyMember.setCreateTime(DateUtils.getNowDate());
        return excellentPartyMemberMapper.insertExcellentPartyMember(excellentPartyMember);
    }

    /**
     * 修改优秀党员
     * 
     * @param excellentPartyMember 优秀党员
     * @return 结果
     */
    @Override
    public int updateExcellentPartyMember(ExcellentPartyMember excellentPartyMember)
    {
        excellentPartyMember.setUpdateTime(DateUtils.getNowDate());
        return excellentPartyMemberMapper.updateExcellentPartyMember(excellentPartyMember);
    }

    /**
     * 批量删除优秀党员
     * 
     * @param ids 需要删除的优秀党员主键
     * @return 结果
     */
    @Override
    public int deleteExcellentPartyMemberByIds(Long[] ids)
    {
        return excellentPartyMemberMapper.deleteExcellentPartyMemberByIds(ids);
    }

    /**
     * 删除优秀党员信息
     * 
     * @param id 优秀党员主键
     * @return 结果
     */
    @Override
    public int deleteExcellentPartyMemberById(Long id)
    {
        return excellentPartyMemberMapper.deleteExcellentPartyMemberById(id);
    }

    @Override
    public long queryExcellentPartyMemberCount(Integer year, String beginDate) {
        return excellentPartyMemberMapper.selectExcellentPartyMemberCounts(year, beginDate);
    }
}
