package com.ruoyi.system.domain.house.vo;

import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class HouseResourceExport {

    @Excel(name = "二级网格")
    private String wgName2;

    @Excel(name = "三级网格")
    private String wgName3;

    @Excel(name = "四级网格")
    private String wgName4;

    @Excel(name = "类型", readConverterExp = "1=楼宇,4=道路,5=街区,6=综合体,7=市场")
    private int type;

    private List<String> businessEntityInfoNames;

    @Excel(name = "所属门牌号")
    private String houseNumber;

    private int houseResourceType;

    @Excel(name = "房源类型")
    private String houseResourceTypeText;

    @Excel(name = "房源面积")
    private BigDecimal houseArea;

    private int houseResourceAttribute;

    @Excel(name = "房源属性")
    private String houseResourceAttributeText;

    @Excel(name = "产权人联系方式")
    private String houseResourceEquityTel;

    @Excel(name = "产权人归属")
    private String ownership;

    @Excel(name = "地址")
    private String address;

    @Excel(name = "负责人")
    private String principal;

    @Excel(name = "负责人联系方式")
    private String principalTel;

    @Excel(name = "主营业务")
    private String business;

    @Excel(name = "工作人员数量")
    private Integer workerNumber;

    @Excel(name = "性质")
    private String nature;

    @Excel(name = "注册地址")
    private String registeredAddress;

    @Excel(name = "行业分类")
    private String industryClassification;

    @Excel(name = "是否规上企业", readConverterExp = "0=否,1=是")
    private Boolean gs;

    @Excel(name = "备注")
    private String remark;
}
