package com.ruoyi.system.service.house.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.system.domain.house.HouseResource;
import com.ruoyi.system.domain.house.vo.HouseResourcePageQuery;
import com.ruoyi.system.mapper.house.HouseResourceMapper;
import com.ruoyi.system.service.house.HouseResourceService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;
import java.util.UUID;

@Service
public class HouseResourceServiceImpl implements HouseResourceService {

    private final HouseResourceMapper houseResourceMapper;

    public HouseResourceServiceImpl(HouseResourceMapper houseResourceMapper) {
        this.houseResourceMapper = houseResourceMapper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveHouseResource(HouseResource houseResource) {
        houseResource.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        houseResourceMapper.insertHouseResource(houseResource);
    }

    @Override
    public HouseResource queryHouseResourceById(String id) {
        return houseResourceMapper.selectHouseResourceById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateHouseResource(HouseResource houseResource) {
        houseResourceMapper.updateHouseResource(houseResource);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteHouseResourceById(String id) {
        houseResourceMapper.deleteHouseResourceById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveHouseResources(List<HouseResource> houseResources) {
        houseResourceMapper.batchInsertHouseResources(houseResources);
    }

    @Override
    public IPage<HouseResource> pageHouseResources(HouseResourcePageQuery query) {
        return houseResourceMapper.selectPage(new Page<>(query.getPageNum(), query.getPageSize()), query);
    }
}
