/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.JavaVersionUtils;
import com.taobao.arthas.common.PidUtils;
import com.taobao.arthas.core.command.model.PerfCounterModel;
import com.taobao.arthas.core.command.model.PerfCounterVO;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.management.counter.Counter;
import sun.management.counter.perf.PerfInstrumentation;

@Name(value="perfcounter")
@Summary(value="Display the perf counter information.")
@Description(value="\nExamples:\n  perfcounter\n  perfcounter -d\n\nWIKI:\n  https://arthas.aliyun.com/doc/perfcounter")
public class PerfCounterCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(PerfCounterCommand.class);
    private static Object perfObject;
    private static Method attachMethod;
    private boolean details;

    @Option(shortName="d", longName="details", flag=true)
    @Description(value="print all perf counter details")
    public void setDetails(boolean details) {
        this.details = details;
    }

    @Override
    public void process(CommandProcess process) {
        List<Counter> perfCounters = PerfCounterCommand.getPerfCounters();
        if (perfCounters.isEmpty()) {
            process.end(1, "please check arthas log. if java version >=9 , try to add jvm options when start your process: --add-opens java.base/jdk.internal.perf=ALL-UNNAMED --add-exports java.base/jdk.internal.perf=ALL-UNNAMED");
            return;
        }
        ArrayList<PerfCounterVO> perfCounterVOs = new ArrayList<PerfCounterVO>();
        for (Counter counter : perfCounters) {
            PerfCounterVO perfCounterVO = new PerfCounterVO(counter.getName(), counter.getValue());
            if (this.details) {
                perfCounterVO.setUnits(counter.getUnits().toString());
                perfCounterVO.setVariability(counter.getVariability().toString());
            }
            perfCounterVOs.add(perfCounterVO);
        }
        process.appendResult(new PerfCounterModel(perfCounterVOs, this.details));
        process.end();
    }

    private static List<Counter> getPerfCounters() {
        try {
            if (perfObject == null) {
                String perfClassName = "sun.misc.Perf";
                if (!JavaVersionUtils.isLessThanJava9()) {
                    perfClassName = "jdk.internal.perf.Perf";
                }
                Class<?> perfClass = ClassLoader.getSystemClassLoader().loadClass(perfClassName);
                Method getPerfMethod = perfClass.getDeclaredMethod("getPerf", new Class[0]);
                perfObject = getPerfMethod.invoke(null, new Object[0]);
            }
            if (attachMethod == null) {
                attachMethod = perfObject.getClass().getDeclaredMethod("attach", Integer.TYPE, String.class);
            }
            ByteBuffer buffer = (ByteBuffer)attachMethod.invoke(perfObject, (int)PidUtils.currentLongPid(), "r");
            PerfInstrumentation perfInstrumentation = new PerfInstrumentation(buffer);
            return perfInstrumentation.getAllCounters();
        }
        catch (Throwable e) {
            logger.error("get perf counter error", e);
            return Collections.emptyList();
        }
    }
}

