package com.ruoyi.system.service.house.impl;

import com.ruoyi.system.domain.grid.GridCompany;
import com.ruoyi.system.domain.grid.GridShop;
import com.ruoyi.system.domain.house.HouseResourceAssociationObject;
import com.ruoyi.system.domain.house.vo.HouseResourceAssociationObjectVo;
import com.ruoyi.system.mapper.grid.GridCompanyMapper;
import com.ruoyi.system.mapper.grid.GridShopMapper;
import com.ruoyi.system.mapper.house.HouseResourceAssociationObjectMapper;
import com.ruoyi.system.service.house.HouseResourceAssociationObjectService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
public class HouseResourceAssociationObjectServiceImpl implements HouseResourceAssociationObjectService {

    private final HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper;

    private final GridCompanyMapper gridCompanyMapper;

    private final GridShopMapper gridShopMapper;

    public HouseResourceAssociationObjectServiceImpl(HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper, GridCompanyMapper gridCompanyMapper, GridShopMapper gridShopMapper) {
        this.houseResourceAssociationObjectMapper = houseResourceAssociationObjectMapper;
        this.gridCompanyMapper = gridCompanyMapper;
        this.gridShopMapper = gridShopMapper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveHouseResourceAssociationObject(HouseResourceAssociationObject houseResourceAssociationObject) {
        houseResourceAssociationObject.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        houseResourceAssociationObjectMapper.insertHouseResourceObjectAssociation(houseResourceAssociationObject);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateHouseResourceAssociationObject(HouseResourceAssociationObject houseResourceAssociationObject) {
        houseResourceAssociationObjectMapper.updateHouseResourceObjectAssociation(houseResourceAssociationObject);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteHouseResourceAssociationObjectById(String id) {
        houseResourceAssociationObjectMapper.deleteHouseResourceObjectAssociationById(id);
    }

    @Override
    public HouseResourceAssociationObjectVo queryHouseResourceAssociationObjectByHouseResourceIdType(String houseResourceId, int type) {
        List<HouseResourceAssociationObject> houseResourceAssociationObject = houseResourceAssociationObjectMapper.selectHouseResourceObjectAssociationByHouseResourceIdType(houseResourceId, type);
        if (Objects.isNull(houseResourceAssociationObject)) {
            return null;
        }
        List<GridCompany> gridCompanyList = new ArrayList<>();
        List<GridShop> gridShopList = new ArrayList<>();
        HouseResourceAssociationObjectVo houseResourceAssociationObjectVo = new HouseResourceAssociationObjectVo();
        for (HouseResourceAssociationObject resourceAssociationObject : houseResourceAssociationObject) {
            if (resourceAssociationObject.getType() == 1) {
                GridCompany gridCompany = gridCompanyMapper.selectByPrimaryKey(resourceAssociationObject.getBusinessId());
                gridCompanyList.add(gridCompany);
            } else if (resourceAssociationObject.getType() == 2) {
                GridShop gridShop = gridShopMapper.selectByPrimaryKey(Long.parseLong(resourceAssociationObject.getBusinessId()));
                gridShopList.add(gridShop);
            }
        }
        houseResourceAssociationObjectVo.setGridCompanyList(gridCompanyList);
        houseResourceAssociationObjectVo.setGridShopList(gridShopList);
        return houseResourceAssociationObjectVo;
    }
}
