package com.ruoyi.party.service.api;

import com.ruoyi.party.domain.PartyOrganizationError;

import java.util.List;

/**
 * 党组织管理Service接口
 * 
 * @author ruoyi
 * @date 2024-05-21
 */
public interface IPartyOrganizationErrorService 
{
    /**
     * 查询党组织管理
     * 
     * @param id 党组织管理主键
     * @return 党组织管理
     */
    public PartyOrganizationError selectPartyOrganizationErrorById(Long id);

    /**
     * 查询党组织管理列表
     * 
     * @param partyOrganizationError 党组织管理
     * @return 党组织管理集合
     */
    public List<PartyOrganizationError> selectPartyOrganizationErrorList(PartyOrganizationError partyOrganizationError);

    /**
     * 新增党组织管理
     * 
     * @param partyOrganizationError 党组织管理
     * @return 结果
     */
    public int insertPartyOrganizationError(PartyOrganizationError partyOrganizationError);

    /**
     * 修改党组织管理
     * 
     * @param partyOrganizationError 党组织管理
     * @return 结果
     */
    public int updatePartyOrganizationError(PartyOrganizationError partyOrganizationError);

    /**
     * 批量删除党组织管理
     * 
     * @param ids 需要删除的党组织管理主键集合
     * @return 结果
     */
    public int deletePartyOrganizationErrorByIds(Long[] ids);

    /**
     * 删除党组织管理信息
     * 
     * @param id 党组织管理主键
     * @return 结果
     */
    public int deletePartyOrganizationErrorById(Long id);
}
