/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.reflect;

import com.taobao.arthas.core.util.ArthasCheckUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ArthasReflectUtils {
    public static Set<Class<?>> getClasses(ClassLoader loader, String packname) {
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = packname;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = loader.getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ArthasReflectUtils.findAndAddClassesInPackageByFile(packageName, filePath, true, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (!name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Class.forName(packageName + '.' + className));
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        });
        if (dirfiles != null) {
            for (File file : dirfiles) {
                if (file.isDirectory()) {
                    ArthasReflectUtils.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                    continue;
                }
                String className = file.getName().substring(0, file.getName().length() - 6);
                try {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Field field, Object value, Object target) throws IllegalArgumentException, IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    public static Set<Field> getFields(Class<?> clazz) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        Class<?> parentClazz = clazz.getSuperclass();
        Collections.addAll(fields, clazz.getDeclaredFields());
        if (null != parentClazz) {
            fields.addAll(ArthasReflectUtils.getFields(parentClazz));
        }
        return fields;
    }

    public static Field getField(Class<?> clazz, String name) {
        for (Field field : ArthasReflectUtils.getFields(clazz)) {
            if (!ArthasCheckUtils.isEquals(field.getName(), name)) continue;
            return field;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getFieldValueByField(Object target, Field field) throws IllegalArgumentException, IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(target);
            return (T)object;
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    public static <T> T valueOf(Class<T> t, String value) {
        if (ArthasCheckUtils.isIn(t, Integer.TYPE, Integer.class)) {
            return (T)Integer.valueOf(value);
        }
        if (ArthasCheckUtils.isIn(t, Long.TYPE, Long.class)) {
            return (T)Long.valueOf(value);
        }
        if (ArthasCheckUtils.isIn(t, Double.TYPE, Double.class)) {
            return (T)Double.valueOf(value);
        }
        if (ArthasCheckUtils.isIn(t, Float.TYPE, Float.class)) {
            return (T)Float.valueOf(value);
        }
        if (ArthasCheckUtils.isIn(t, Character.TYPE, Character.class)) {
            return (T)Character.valueOf(value.charAt(0));
        }
        if (ArthasCheckUtils.isIn(t, Byte.TYPE, Byte.class)) {
            return (T)Byte.valueOf(value);
        }
        if (ArthasCheckUtils.isIn(t, Boolean.TYPE, Boolean.class)) {
            return (T)Boolean.valueOf(value);
        }
        if (ArthasCheckUtils.isIn(t, Short.TYPE, Short.class)) {
            return (T)Short.valueOf(value);
        }
        if (ArthasCheckUtils.isIn(t, String.class)) {
            return (T)value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> defineClass(ClassLoader targetClassLoader, String className, byte[] classByteArray) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method defineClassMethod;
        Method method = defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        synchronized (method) {
            Class clazz;
            boolean acc = defineClassMethod.isAccessible();
            try {
                defineClassMethod.setAccessible(true);
                clazz = (Class)defineClassMethod.invoke((Object)targetClassLoader, className, classByteArray, 0, classByteArray.length);
                defineClassMethod.setAccessible(acc);
            }
            catch (Throwable throwable) {
                defineClassMethod.setAccessible(acc);
                throw throwable;
            }
            return clazz;
        }
    }
}

