package com.ruoyi.party.mapper;

import com.ruoyi.party.domain.PartyActivity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * 党员活动Mapper接口
 * 
 * @author ruoyi
 * @date 2024-05-15
 */
public interface PartyActivityMapper 
{
    /**
     * 查询党员活动
     * 
     * @param id 党员活动主键
     * @return 党员活动
     */
    public PartyActivity selectPartyActivityById(String id);

    /**
     * 查询党员活动列表
     * 
     * @param partyActivity 党员活动
     * @return 党员活动集合
     */
    List<PartyActivity> selectPartyActivityList(PartyActivity partyActivity);

    /**
     * 新增党员活动
     * 
     * @param partyActivity 党员活动
     * @return 结果
     */
    public int insertPartyActivity(PartyActivity partyActivity);

    /**
     * 修改党员活动
     * 
     * @param partyActivity 党员活动
     * @return 结果
     */
    public int updatePartyActivity(PartyActivity partyActivity);

    /**
     * 删除党员活动
     * 
     * @param id 党员活动主键
     * @return 结果
     */
    public int deletePartyActivityById(String id);

    /**
     * 批量删除党员活动
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deletePartyActivityByIds(String[] ids);

    List<Map<String, Object>> getPartyActivity(@Param("orgId")String orgId);

}
