/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.location;

import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.location.Location;
import com.alibaba.bytekit.asm.location.LocationMatcher;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnNode;
import java.util.ArrayList;
import java.util.List;

public class SyncLocationMatcher
implements LocationMatcher {
    private int count;
    boolean whenComplete;
    int opcode;

    public SyncLocationMatcher(int opcode, int count, boolean whenComplete) {
        if (194 != opcode && 195 != opcode) {
            throw new IllegalArgumentException("SyncLocationMatcher only support Opcodes.MONITORENTER or Opcodes.MONITOREXIT.");
        }
        this.opcode = opcode;
        this.count = count;
        this.whenComplete = whenComplete;
    }

    @Override
    public List<Location> match(MethodProcessor methodProcessor) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int matchedCount = 0;
        for (AbstractInsnNode insnNode = methodProcessor.getEnterInsnNode(); insnNode != null; insnNode = insnNode.getNext()) {
            InsnNode node;
            if (!(insnNode instanceof InsnNode) || (node = (InsnNode)insnNode).getOpcode() != this.opcode || this.count > 0 && this.count != ++matchedCount) continue;
            Location.SyncEnterLocation location = new Location.SyncEnterLocation(node, matchedCount, this.whenComplete);
            locations.add(location);
        }
        return locations;
    }
}

