package com.ruoyi.system.service.grid;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridPeople;
import com.ruoyi.system.domain.grid.GridPeopleExample;
import com.ruoyi.system.domain.grid.ext.GridPeopleExt;
import com.ruoyi.system.domain.grid.vo.GridPeopleSearchParam;
import com.ruoyi.system.domain.grid.vo.PeopleBindParam;
import com.ruoyi.system.service.BaseService;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridPeopleService接口
 */
public interface GridPeopleService extends BaseService<GridPeople, GridPeopleExample> {

    PageInfo page(GridPeople wsPeople, String value);

    AjaxResult add(GridPeople wsPeople);

    AjaxResult edit(GridPeople wsPeople);

    AjaxResult detail(String id);

    AjaxResult delete(String id);

    AjaxResult detailByIdCard(String idCard);

    GridPeople detailByOpenId(String openId);

    int countByIdCardOrPhone(String idCard, String phone, String id);

    // GridPeopleExt查询字典的value值
    GridPeopleExt selectGridPeopleExt(GridPeopleExt wsPeopleExt);

    GridPeopleExt dealPeopleExt(Map<String, String> wgxxbMap, Map<String, String> commonMap, GridPeopleExt wsPeopleExt);

    // 人口类型数量统计
    List<Map<String, Object>> countGridPeople(String wgCode);

    List<Map<String, Object>> countGridPeopleByRkbq(String wgCode);

    // 特殊人口标签的数量
    Integer countSpecialPeople(String wgCode);

    // 人口数量总量统计
    int countAll(String wgCode);

    // 各村社区数量统计
    List<Map<String, Object>> countGridPeopleByGrid();

    // 各村社区/各村社区下三级网格 人口类型数量统计
    List<Map<String, Object>> countGridPeopleRklxByGrid(String wgCode);

    // 根据身份证号查询
    List<GridPeople> selectGridPeopleByIdCard(String idCard);

    AjaxResult peopleToHousePage(String peopleId, int pageNum, int pageSize);

    AjaxResult peopleToCompanyPage(String peopleId, int pageNum, int pageSize);

    AjaxResult peopleToShopPage(String peopleId, int pageNum, int pageSize);

    AjaxResult peopleBind(PeopleBindParam peopleBindParam);

    AjaxResult importExcel(MultipartFile file, String createId);

    List<GridPeople> getAllPeople(GridPeopleSearchParam param);

}
