package com.ruoyi.system.service.md.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.zqt.ZQTConcurrencyHelper;
import com.ruoyi.system.domain.md.NewmsgOutbox;
import com.ruoyi.system.domain.md.dto.UnionInboxDto;
import com.ruoyi.system.domain.md.request.NewMsgQuery;
import com.ruoyi.system.service.md.NewmsgAppService;
import com.ruoyi.system.service.md.NewMsgService;
import com.ruoyi.system.service.md.NewmsgReplyService;
import com.ruoyi.system.service.system.ISysDeptService;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author vidar
 * date 2024/6/6
 * description
 **/
@Service
public class NewmsgAppServiceImpl implements NewmsgAppService {
    @Resource
    private NewMsgService newMsgService;
    @Resource
    private NewmsgReplyService replyService;
    @Resource
    private ISysDeptService deptService;

    @Override
    public IPage<UnionInboxDto> queryUnion(NewMsgQuery query){
        IPage<Map<String,Object>> reportPage = newMsgService.queryUnion(query,query);
        List<Runnable> runs = Lists.newArrayList();
        IPage<UnionInboxDto> res = convertPage(reportPage, old -> {
            UnionInboxDto dto = new UnionInboxDto();
            try {
                BeanUtils.populate(dto, old);
            }catch (Exception e){
                e.printStackTrace();
            }
            dto.setCtimeVo(DateUtils.getDateTime(dto.getCtime()));

            old.putIfAbsent("publicReply", "1");
            String publicReply = old.get("publicReply").toString();

            runs.add(()->{

                if(publicReply.equals("0")) {
                    NewmsgOutbox outbox = newMsgService.getOutboxDetailNoBody(dto.getOutboxid());
                    if (outbox != null) {
                        List<String> userIds = Arrays.asList(query.getToUserid(), outbox.getUserid());
                        NewMsgQuery _q = new NewMsgQuery();
                        _q.setToUserid(null);
                        _q.setToOrgid(null);
                        _q.setNullReplypid(true);
                        _q.setUserids(userIds);
                        _q.setOutboxid(dto.getOutboxid());
                        dto.setReplyNum(replyService.count(_q));
                    }
                }else{
                    NewMsgQuery _q = new NewMsgQuery();
                    _q.setOutboxid(dto.getOutboxid());
                    dto.setReplyNum(replyService.count(_q));
                }

                if(StringUtils.isNotBlank(dto.getFromDeptid())){
                    SysDept dept = deptService.selectDeptById(Long.valueOf(dto.getFromDeptid()));
                    dto.setFromDeptName(dept==null?"":dept.getDeptName());
                }
            });
            return dto;
        });

        ZQTConcurrencyHelper.doMutli(runs);
        runs.clear();
        return res;
    }

    private <F, T> IPage<T> convertPage(IPage<F> old, Function<? super F, ? extends T> function){
        IPage<T> res = new Page<>();
        if(old == null){
            res.setRecords(Lists.newArrayList());
            return res;
        }
        res.setPages(old.getPages());
        res.setTotal(old.getTotal());
        res.setCurrent(old.getCurrent());
        res.setSize(old.getSize());
        if(!CollectionUtils.isEmpty(old.getRecords())){
            res.setRecords(new ArrayList<>(Lists.transform(old.getRecords(),function)));
        }else{
            res.setRecords(Lists.newArrayList());
        }
        return res;
    }
}
