package com.ruoyi.system.service.grid.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.system.domain.grid.*;
import com.ruoyi.system.domain.grid.ext.GridPeopleExt;
import com.ruoyi.system.domain.system.SysOtherappAttachment;
import com.ruoyi.system.domain.system.SysOtherappAttachmentExample;
import com.ruoyi.system.domain.system.enums.AttachEnums;
import com.ruoyi.system.domain.visit.enums.VisitTypeEnum;
import com.ruoyi.system.domain.visit.ext.VisitFreeInterviewExt;
import com.ruoyi.system.mapper.grid.GridPublicOpinionsMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.*;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.system.SysOtherappAttachmentService;
import com.ruoyi.system.service.visit.VisitFreeInterviewService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridPublicOpinionsService实现
 */
@Service
public class GridPublicOpinionsServiceImpl extends BaseServiceImpl<GridPublicOpinionsMapper, GridPublicOpinions, GridPublicOpinionsExample> implements GridPublicOpinionsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridPublicOpinionsServiceImpl.class);

    @Autowired
    GridPublicOpinionsMapper GridPublicOpinionsMapper;
    @Autowired
    private SysOtherappAttachmentService SysOtherappAttachmentService;
    @Autowired
    private GridRegionService bsWgxxbService;
    @Autowired
    private GridPeopleService wsPeopleService;
    @Autowired
    private VisitFreeInterviewService wszfFreeInterviewService;
    @Autowired
    private GridRegionUserService bsWgxxUserService;
    @Autowired
    private GridWgLogService wsWgLogService;
    @Autowired
    private ISysUserService sysUserService;

    @Override
    public List<GridPublicOpinions> page(String peopleId) {
        GridPublicOpinionsExample ex = new GridPublicOpinionsExample();
        GridPublicOpinionsExample.Criteria ca = ex.createCriteria();
        ca.andPeopleIdEqualTo(peopleId);
        ex.setOrderByClause(" service_time desc, create_time desc ");
        List<GridPublicOpinions> list = GridPublicOpinionsMapper.selectByExample(ex);
        for (GridPublicOpinions GridPublicOpinions : list) {
            SysOtherappAttachmentExample ex1 = new SysOtherappAttachmentExample();
            SysOtherappAttachmentExample.Criteria ca1 = ex1.createCriteria();
            ca1.andAttachTypeEqualTo(AttachEnums.AttachType.PUBLIC_OPINIONS.name());
            ca1.andBusinessIdEqualTo(GridPublicOpinions.getId());
            List<SysOtherappAttachment> attachmentList = SysOtherappAttachmentService.selectByExample(ex1);
            GridPublicOpinions.setAttachmentList(attachmentList);
        }
        return list;
    }

    @Override
    @Transactional
    public String add(GridPublicOpinions GridPublicOpinions) {
        VisitFreeInterviewExt wszfFreeInterviewExt = new VisitFreeInterviewExt();
        GridPublicOpinions.setId(IdUtil.fastSimpleUUID());
        GridPublicOpinions.setCreateTime(DateUtil.formatDateTime(new Date()));
        GridPublicOpinions.setWgValue(bsWgxxbService.getWgName(GridPublicOpinions.getWgCode()));
        GridRegion bsWgxxb = bsWgxxbService.getSecondWgCode(GridPublicOpinions.getWgCode());
        if (bsWgxxb != null) {
            GridPublicOpinions.setCountry(bsWgxxb.getWgName());
        }
        if (CollectionUtils.isNotEmpty(GridPublicOpinions.getAttachmentList())) {
            for (SysOtherappAttachment at : GridPublicOpinions.getAttachmentList()) {
                at.setAttachType(AttachEnums.AttachType.PUBLIC_OPINIONS.name());
                at.setBusinessId(GridPublicOpinions.getId());
                SysOtherappAttachmentService.insertSelective(at);
            }
            wszfFreeInterviewExt.setOtherappAttachments(GridPublicOpinions.getAttachmentList());
        }
        GridPublicOpinionsMapper.insertSelective(GridPublicOpinions);

        // 调用新增自由走访数据
        wszfFreeInterviewExt.setWgCode(GridPublicOpinions.getWgCode());
        wszfFreeInterviewExt.setWgValue(bsWgxxbService.getWgName(GridPublicOpinions.getWgCode()));
        GridRegionUser bsWgxxUser = bsWgxxUserService.selectByUserId(GridPublicOpinions.getCreateId());
        wszfFreeInterviewExt.setWgyCode(bsWgxxUser != null ? bsWgxxUser.getWgId() : "");
        wszfFreeInterviewExt.setWgyName(GridPublicOpinions.getServiceName());
        wszfFreeInterviewExt.setInterviewTime(GridPublicOpinions.getServiceTime());
        wszfFreeInterviewExt.setType("4");
        wszfFreeInterviewExt.setContent(GridPublicOpinions.getContent());
        wszfFreeInterviewExt.setObjId(GridPublicOpinions.getPeopleId());
        wszfFreeInterviewExt.setLongitude(GridPublicOpinions.getLongitude());
        wszfFreeInterviewExt.setLatitude(GridPublicOpinions.getLatitude());
        wszfFreeInterviewExt.setAddress(GridPublicOpinions.getAddress());
        wszfFreeInterviewExt.setActualTime(GridPublicOpinions.getCreateTime());

        GridPeopleExt wsPeopleExt = (GridPeopleExt) wsPeopleService.detail(GridPublicOpinions.getPeopleId()).get("data");
        if (wsPeopleExt != null) {
            wszfFreeInterviewExt.setObjName(wsPeopleExt.getPersonName());
            wszfFreeInterviewExt.setObjType(wsPeopleExt.getRklxCode());
            wszfFreeInterviewExt.setObjTypeName(wsPeopleExt.getRklxValue());
        }
        wszfFreeInterviewExt.setVisitType(VisitTypeEnum.FREE_VISIT.getCode());
        wszfFreeInterviewService.addVisitFreeInterview(wszfFreeInterviewExt);

        // 日志
        SysUser sysUser = sysUserService.selectUserById(GridPublicOpinions.getCreateId());
        GridWgLog wsWgLog = new GridWgLog();
        wsWgLog.setCreateId(GridPublicOpinions.getCreateId());
        wsWgLog.setCreateName(sysUser != null ? sysUser.getNickName() : "");
        wsWgLog.setCreateWgCode(GridPublicOpinions.getWgCode());
        wsWgLog.setObjectName(GridPublicOpinions.getPersonName());
        wsWgLog.setType("1");
        wsWgLog.setOperate("interview");
        wsWgLog.setObjectId(GridPublicOpinions.getId());
        wsWgLogService.add(wsWgLog);

        return GridPublicOpinions.getId();
    }

    @Override
    public void edit(GridPublicOpinions GridPublicOpinions) {
        Validator.validateNotEmpty(GridPublicOpinions.getId(), "id is empty");
        GridPublicOpinionsMapper.updateByPrimaryKeySelective(GridPublicOpinions);
    }

    @Override
    public GridPublicOpinions detail(String id) {
        GridPublicOpinions GridPublicOpinions = GridPublicOpinionsMapper.selectByPrimaryKey(id);
        if (GridPublicOpinions != null) {
            SysOtherappAttachmentExample ex = new SysOtherappAttachmentExample();
            SysOtherappAttachmentExample.Criteria ca = ex.createCriteria();
            ca.andAttachTypeEqualTo(AttachEnums.AttachType.PUBLIC_OPINIONS.name());
            ca.andBusinessIdEqualTo(id);
            List<SysOtherappAttachment> attachmentList = SysOtherappAttachmentService.selectByExample(ex);
            GridPublicOpinions.setAttachmentList(attachmentList);
            return GridPublicOpinions;
        }
        return null;
    }

    @Override
    @Transactional
    public void delete(String ids) {
        String[] idArray = ids.split(",");
        for (String idStr : idArray) {
            if (StringUtils.isBlank(idStr)) {
                continue;
            }
            SysOtherappAttachmentExample ex = new SysOtherappAttachmentExample();
            SysOtherappAttachmentExample.Criteria ca = ex.createCriteria();
            ca.andBusinessIdEqualTo(idStr);
            SysOtherappAttachmentService.deleteByExample(ex);
            GridPublicOpinionsMapper.deleteByPrimaryKey(idStr);
        }
    }
}
