package com.ruoyi.system.service.task;

import com.alibaba.fastjson2.JSONArray;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridItemDaily;
import com.ruoyi.system.domain.grid.vo.GridWgBean;
import com.ruoyi.system.domain.task.*;
import com.ruoyi.system.domain.task.dto.TaskCommonParams;
import com.ruoyi.system.domain.task.vo.LeaderPojo;
import com.ruoyi.system.domain.task.vo.UserPojo;
import com.ruoyi.system.service.BaseService;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc TkCommonTaskService接口
 */
public interface TkCommonTaskService extends BaseService<TkCommonTask, TkCommonTaskExample> {

    int saveTask(TkCommonTask tkCommonTask, TkCommonReport tkCommonReport, List<GridItemDaily> itemDailyList, AjaxResult result, TkCommonAssigned tkCommonAssigned, AjaxResult beassignedUserIds);

    PageInfo<TkCommonTask> selectList(TaskCommonParams map, Integer pageNum, Integer pageSize);

    List<TkCommonTask> selectListByExport(TaskCommonParams map);

    int saveDynamic2(String id, String userName, String address, Date time, String node, String cuiBanReason);

    int panding(TkCommonTask tkCommonTask, String userName, String address, Date time, String node, String reason);

    int pingfen(TkCommonTask tkCommonTask, String userName, String address, Date time, String node, String reason);

    int agreeTask(TkCommonTask tkCommonTask, String id, String userName, String address, Date time, String node, boolean isAgree, String returnReason, String loginUserId);

    int agreeBack(TkCommonTask tkCommonTask, String id, String userName, String address, Date time, String node, boolean isAgree, String returnReason, String loginUserId);

    int startTask(TkCommonTask tkCommonTask, String id, String userName, String address, Date time, String node, String loginUserRole, String loginUserId,   AjaxResult result2, String loginWgCode, String level);

    int verificationPerson(TkCommonTask tkCommonTask, String id, String userName, String address, Date time, String node, String loginUserId);

    int verificationPerson2(TkCommonTask tkCommonTask, String id, String userName, String address, Date time, String node, String loginUserId);

    int jumpOverHecha(TkCommonTask tkCommonTask, String id, String userName, String address, Date time, String node, String loginUserId);

    int verificationTask(TkCommonTask tkCommonTask, String id, String userName, String address, Date time, String node);

    int evaluationTask(TkCommonTask tkCommonTask, String id, String userName, String address, Date time, String node);

    int reportLeader(TkCommonTask tkCommonTask, TkCommonReport tkCommonReport, String loginUserName, String loginUserGrid, String loginUserId, AjaxResult result2);

    int insertLeaders(String id, String loginUserId, JSONArray leaders, String loginUserName, String loginUserGrid);

    int saveReceiveAndDynaAndMSG(LeaderPojo pojo,   int type);

    int leaveMessage(LeaderPojo pojo);

    int querenDy(String id, String loginUserName, String loginUserBelongGrid, String node, String reason);

    int insertXieTiao(String id, String loginUserId, JSONArray leaders, String loginUserName, String loginUserGrid);

    int insertQianPi(String id, String note, String loginUserId, JSONArray leaders, String loginUserName, String loginUserGri);

    int applyDelay(TkCommonTask tkCommonTask, String loginUserName, String loginUserGrid, String loginUserId);

    int agreeDelay(TkCommonTask tkCommonTask, TkCommonAssigned tkCommonAssigned, String loginUserName, String loginUserGrid, String node, String loginUserId,   boolean isAgree, String assignedUserId);

    int revert(List<TkCommonTask> tkCommonTasks);

    int backPuTong(List<TkCommonTask> tkCommonTasks);

    int delete2(String[] split);

    int solveBySelf(TkCommonTask tkCommonTask, String loginUserName, String loginUserBelongGrid, TkCommonAssigned TkCommonAssigned);

    List<Map<String, Object>> bigWindowWGCount(Map map);

    List<Map<String, Object>> taskCountByComeFrom(Map map);

    List<Map<String, Object>> taskCountByBaseId(Map map);

    boolean checkCuiBan(String id);

    List<Map<String, Object>> selectMatterRank(Map map);

    List<Map<String, Object>> selectMatterRankThreeType(Map map);

    List<Map<String, Object>> manyiRank(Map map);

    List<Map<String, Object>> personManYiTJ(Map map);

    List<TkCommonTask> taskListByWgCode(Map map);

    List<Map<String, Object>> taskCountByWgcode(Map map);

    List<Map<String, Object>> groupByMatterType(Map map);

    List<Map<String, Object>> groupByPriority(Map map);


    List<Map<String, Object>> taskCountBySecWgcode(Map map);

    List<Map<String, Object>> taskCountByThirdWgcode(Map map);

    List<Map<String, Object>> selectMatterRankByWg(Map map);

    List<Map<String, Object>> getTaskByUserId(Map map);

    int zhuanzhifajv(TkCommonTask tkCommonTask);

    List<Map<String, Object>> enviromentManStatistic(Map map);

    List<Map<String, Object>> enviromentMatterStatistic(Map map);

    List<GridWgBean> countTaskBySq(Map map);

    PageInfo<Map<String, Object>> selectTaskList(String userName, Integer pageSize, Integer pageNum);

    int saveDynamicByType(String id, String userName, String address, Date time, String node, String reason);
    String saveReceiveAndBackNode(String id, String note, int type, List<UserPojo> leaders, String leaderNames);
    TkCommonTaskDynamic getTkCommonTaskDynamic(String id, String loginUserName, String loginUserBelongGrid, String performUserName, String performUserGrid);
}
