package com.ruoyi.party.mapper;

import com.ruoyi.party.domain.ExcellentPartyMember;
import com.ruoyi.party.domain.vo.ExcellentPartyMemberVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 优秀党员Mapper接口
 * 
 * @author ruoyi
 * @date 2024-05-27
 */
public interface ExcellentPartyMemberMapper 
{
    /**
     * 查询优秀党员
     * 
     * @param id 优秀党员主键
     * @return 优秀党员
     */
    public ExcellentPartyMember selectExcellentPartyMemberById(Long id);

    /**
     * 查询优秀党员列表
     * 
     * @param excellentPartyMember 优秀党员
     * @return 优秀党员集合
     */
    public List<ExcellentPartyMemberVo> selectExcellentPartyMemberList(ExcellentPartyMember excellentPartyMember);

    List<ExcellentPartyMemberVo> selectExcellentPartyMemberVoList(ExcellentPartyMember excellentPartyMember);

    /**
     * 新增优秀党员
     * 
     * @param excellentPartyMember 优秀党员
     * @return 结果
     */
    public int insertExcellentPartyMember(ExcellentPartyMember excellentPartyMember);

    /**
     * 修改优秀党员
     * 
     * @param excellentPartyMember 优秀党员
     * @return 结果
     */
    public int updateExcellentPartyMember(ExcellentPartyMember excellentPartyMember);

    /**
     * 删除优秀党员
     * 
     * @param id 优秀党员主键
     * @return 结果
     */
    public int deleteExcellentPartyMemberById(Long id);

    /**
     * 批量删除优秀党员
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteExcellentPartyMemberByIds(Long[] ids);


    /**
     * 获取优秀党员总数
     * @param year
     * @param beginDate
     * @return
     */
    long selectExcellentPartyMemberCounts(@Param("year") Integer year, @Param("beginDate") String beginDate);
}
