package com.ruoyi.common.zqt;

import org.apache.commons.lang3.time.DateFormatUtils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import static sun.security.krb5.internal.KerberosTime.now;

public class ZQTDateUtils extends org.apache.commons.lang3.time.DateUtils {

    private static String[] parsePatterns = {"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM",
            "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss",
            "yyyy.MM.dd HH:mm", "yyyy.MM"};
    public static final String FULL_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String FULL_SIMPLE_DATE_PATTERN = "yyyy-MM-dd";
    /**
     * 得到当前日期字符串 格式（yyyy-MM-dd）
     */
    public static String getDate() {
        return getDate("yyyy-MM-dd HH:mm:ss");
    }


    /**
     * 得到当前日期字符串 格式（yyyy-MM-dd） pattern可以为："yyyy-MM-dd" "HH:mm:ss" "E"
     */
    public static String getDate(String pattern) {
        return DateFormatUtils.format(new Date(), pattern);
    }

    /**
     * 得到日期字符串 默认格式（yyyy-MM-dd） pattern可以为："yyyy-MM-dd" "HH:mm:ss" "E"
     */
    public static String formatDate(Date date, Object... pattern) {
        if (date == null) {
            return null;
        }
        String formatDate = null;
        if (pattern != null && pattern.length > 0) {
            formatDate = DateFormatUtils.format(date, pattern[0].toString());
        } else {
            formatDate = DateFormatUtils.format(date, "yyyy-MM-dd");
        }
        return formatDate;
    }

    /**
     * 得到日期时间字符串，转换格式（yyyy-MM-dd HH:mm:ss）
     */
    public static String formatDateTime(Date date) {
        return formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    /**
     * 得到当前时间字符串 格式（HH:mm:ss）
     */
    public static String getTime() {
        return formatDate(new Date(), "HH:mm:ss");
    }

    /**
     * 得到当前日期和时间字符串 格式（yyyy-MM-dd HH:mm:ss）
     */
    public static String getDateTime() {
        return formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateInfo() {
        return formatDate(new Date(), "yyyy-MM-dd");
    }


    /**
     * 得到当前年份字符串 格式（yyyy）
     */
    public static String getYear() {
        return formatDate(new Date(), "yyyy");
    }

    /**
     * 得到当前月份字符串 格式（MM）
     */
    public static String getMonth() {
        return formatDate(new Date(), "MM");
    }

    /**
     * 得到当天字符串 格式（dd）
     */
    public static String getDay() {
        return formatDate(new Date(), "dd");
    }

    /**
     * 得到当前星期字符串 格式（E）星期几
     */
    public static String getWeek() {
        return formatDate(new Date(), "E");
    }

    /**
     * 日期型字符串转化为日期 格式
     * { "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm",
     * "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm",
     * "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm" }
     */
    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return parseDate(str.toString(), parsePatterns);
        } catch (ParseException e) {
            return null;
        }
    }

    /**
     * 获取过去的天数
     *
     * @param date
     * @return
     */
    public static long pastDays(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / (24 * 60 * 60 * 1000);
    }

    /**
     * 获得当前时间的字符串类型
     *
     * @return
     */
    public static String toStr() {
        return toStr(new Date());
    }

    /**
     * Date转成"yyyy-MM-dd HH:mm:ss"格式的字符串
     *
     * @param date
     * @return
     */
    public static String toStr(Date date) {
        return format(date, "yyyy-MM-dd HH:mm:ss");
    }

    /**
     * 将一个 Date 格式化为日期/时间字符串
     *
     * @param date    要格式化为时间字符串的时间值
     * @param pattern 日期和时间格式的模式
     * @return 已格式化的时间字符串
     */
    public static String format(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    /**
     * 获取过去的小时
     *
     * @param date
     * @return
     */
    public static long pastHour(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / (60 * 60 * 1000);
    }

    /**
     * 获取过去的分钟
     *
     * @param date
     * @return
     */
    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / (60 * 1000);
    }

    /**
     * 将毫秒值转换为时间（天,时:分:秒.毫秒）
     *
     * @param timeMillis
     * @return
     */
    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / (24 * 60 * 60 * 1000);
        long hour = (timeMillis / (60 * 60 * 1000) - day * 24);
        long min = ((timeMillis / (60 * 1000)) - day * 24 * 60 - hour * 60);
        long s = (timeMillis / 1000 - day * 24 * 60 * 60 - hour * 60 * 60 - min * 60);
        long sss = (timeMillis - day * 24 * 60 * 60 * 1000 - hour * 60 * 60 * 1000 - min * 60 * 1000 - s * 1000);
        return (day > 0 ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    /**
     * 获取两个日期之间的天数
     *
     * @param before
     * @param after
     * @return
     */
    public static double getDaysBetweenDate(Date before, Date after) {
        return getMillisecBetweenDate(before, after) / (1000 * 60 * 60 * 24);
    }

    /**
     * 获取两个日期之间的毫秒数
     *
     * @param before
     * @param after
     * @return
     */
    public static long getMillisecBetweenDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return afterTime - beforeTime;
    }

    /**
     * 获取当前月的第一天
     *
     * @return
     */
    public static String getFirstDayOfMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        //获取当前月第一天：
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 1);//设置为1号,当前日期既为本月第一天
        String first = format.format(c.getTime());
        return first;
    }

    public static Calendar getWeekCalendar(int year, int week) {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.WEEK_OF_YEAR, week);
        cal.setFirstDayOfWeek(Calendar.MONDAY);

        //设置一年的第一周至少包含新年的多少天，设置为4是对照ISO标准
        cal.setMinimalDaysInFirstWeek(4);

        return cal;
    }

    public static String getCurrentWeekBeginDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        return sdf.format(cal.getTime());
    }

    public static String getCurrentMonthBeginDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 1);//1:本月第一天
        return sdf.format(c.getTime());
    }

    /**
     * 方法名: getDoubleType
     * 描述: 返回时间的 double
     * 参数: @param dateString
     * 参数: @return
     * 参数: @throws ParseException    设定文件
     */
    public static double getDoubleType(String dateString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf.parse(dateString);
        return date.getTime();
    }


    /**
     * 获得两个Date之间的秒数
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return
     */
    public static int calLastedTime(Date startTime, Date endTime) {
        long a = startTime.getTime();
        long b = endTime.getTime();
        int c = (int) ((a - b) / 1000);
        return c;
    }

    /**
     * 获取若干个小时之后的时间（字符串类型）
     *
     * @param startTime
     * @param hours
     * @return
     */
    public static String getPassHours(String startTime, int hours) {
        // 获取一个小时以后的时间
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = df.parse(startTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) + hours);
        return df.format(calendar.getTime());
    }


    /**
     * "yyyy-MM-dd HH:mm:ss"格式的日天期在若干数后的时间（字符串）
     *
     * @param time
     * @param days
     * @return
     */
    public static String getAddDate(String time, int days) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = dateFormat.parse(time);
        } catch (ParseException e) {
            e.printStackTrace();
        } // 指定日期
        Date newDate = null;
        try {
            newDate = addDate(date, days);
        } catch (Exception e) {
            e.printStackTrace();
        } // 指定日期加上20天
        String st = dateFormat.format(newDate);
        return st;
    }

    /**
     * 指定时间在若干天后的时间
     *
     * @param date
     * @param day
     * @return
     * @throws ParseException
     */
    public static Date addDate(Date date, long day){
        long time = date.getTime(); // 得到指定日期的毫秒数
        day = day * 24 * 60 * 60 * 1000; // 要加上的天数转换成毫秒数
        time += day; // 相加得到新的毫秒数
        return new Date(time); // 将毫秒数转换成日期
    }

    /**
     * 获取当天的某一时刻Date
     *
     * @param hour 24小时
     * @param min  分钟
     * @param sec  秒
     * @param mill 毫秒
     * @return
     */
    public static Date getMoment(int hour, int min, int sec, int mill) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, hour);
        calendar.set(Calendar.MINUTE, min);
        calendar.set(Calendar.SECOND, sec);
        calendar.set(Calendar.MILLISECOND, mill);
        return calendar.getTime();
    }


    /**
     * 获取过去或者未来 任意天内的日期数组
     *
     * @param intervals intervals天内
     * @return 日期数组
     */
    public static ArrayList<Date> getDateList(int intervals) {
        ArrayList<Date> pastDaysList = new ArrayList<>();
        for (int i = 0; i < intervals; i++) {
            pastDaysList.add(getPastDate(i));
        }
        return pastDaysList;
    }

    public static ArrayList<Date> getDateList(int intervals,String startTime) {
        ArrayList<Date> pastDaysList = new ArrayList<>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        int d=1;
        for (int i=0;i<intervals;i++) {
            Date parse = formatter.parse(startTime, new ParsePosition(0));
            calendar.setTime(parse);
            //i ---->后几天，-i ---->前几天
            calendar.add(Calendar.DATE, -i);
            Date time = calendar.getTime();
            String toTime = formatter.format(time);
            try {
                pastDaysList.add(formatter.parse(toTime));
            } catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("第" + d + "天：" + toTime);
            d++;
        }
        return pastDaysList;
    }

    /**
     * 获取过去第几天的日期
     *
     * @param past
     * @return
     */
    public static Date getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - past);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String result = format.format(today);
        try {
            return format.parse(result);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 转换时间格式
     * { "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm",
     *  "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm",
     * "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm" }
     * @param time
     * @return
     */
    public static Date getPastDate(String time,String parsePatterns){
        SimpleDateFormat sdf = new SimpleDateFormat(parsePatterns);
        if (time == null) {
            return null;
        }
        try {
            return sdf.parse(time);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getTodayStartTime(Date time) {
        String format1 =null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            String format = sdf1.format(time);
            String start = format.concat(" 00:00:01");
            Date parse = sdf.parse(start);
            format1 = sdf.format(parse);
            System.out.println("某一天的开始：" + format1);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return getPastDate(format1,"yyyy-MM-dd HH:mm:ss");
    }

    public static Date getTodayEndTime(Date time) {
        String format1 =null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            String format = sdf1.format(time);
            String end = format.concat(" 23:59:59");
            Date parse = sdf.parse(end);
            format1 = sdf.format(parse);
            System.out.println("某一天的结束：" + format1);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return getPastDate(format1,"yyyy-MM-dd HH:mm:ss");
    }


    /**
     * @param dayOffset 当前日期往前数天数 负数是往前  正数是往后
     * @return
     */
    public static long getTime(int dayOffset) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DATE, dayOffset);
        Date time = calendar.getTime();
        String format = sdf1.format(time);
        String start = format.concat(" 00:00:01");
        String end = format.concat(" 23:59:59");
        try {
            Date parse = sdf.parse(start);
            String format1 = sdf.format(parse);
            System.out.println("某一天的开始：" + format1);
            Date end1 = sdf.parse(end);
            String end12 = sdf.format(end1);
            System.out.println("某一天的结束：" + end12);
            System.out.println("某一天的结束秒：" + end1.getTime() / 1000);
            System.out.println("某一天的开始秒：" + parse.getTime() / 1000);
            return parse.getTime() / 1000;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return now().getTime() / 1000;
    }

    /**
     * 获得指定某年某月某日某刻的Date
     *
     * @param year  年
     * @param month 月
     * @param day   日
     * @param hour  24小时制
     * @param min   分钟
     * @param sec   秒
     * @param mill  毫秒
     * @return
     */
    public static Date getMoment(int year, int month, int day, int hour, int min, int sec, int mill) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month);
        calendar.set(Calendar.DAY_OF_MONTH, day);
        calendar.set(Calendar.HOUR_OF_DAY, hour);
        calendar.set(Calendar.MINUTE, min);
        calendar.set(Calendar.SECOND, sec);
        calendar.set(Calendar.MILLISECOND, mill);
        return calendar.getTime();
    }

    public static String getMonthEndTime(String time){
        Calendar a = Calendar.getInstance();
        a.set(Calendar.DATE, 1);//把日期设置为当月第一天
        a.roll(Calendar.DATE, -1);//日期回滚一天，也就是最后一天
        //当月有多少天
        int maxDate = a.get(Calendar.DATE);

        SimpleDateFormat sdfTwo = new SimpleDateFormat("yyyy-MM-");
        Date pastDate = getPastDate(time, "yyyy-MM");
        String endTime = sdfTwo.format(pastDate) + maxDate + " 23:59:59";
        return endTime;
    }

    public static String getMonthStartTime(String time){
        Calendar a = Calendar.getInstance();
        a.set(Calendar.DATE, 1);//把日期设置为当月第一天
        a.roll(Calendar.DATE, -1);//日期回滚一天，也就是最后一天

        SimpleDateFormat sdfTwo = new SimpleDateFormat("yyyy-MM-");
        String startTime = sdfTwo.format(getPastDate(time,"yyyy-MM")) + "01 00:00:00";
        return startTime;
    }

    /*
     * 获取两日期之间的日期
     */
    public static List<String> getDateStrsBetween(Date d1, Date d2){
        List<String> result = new ArrayList<String>();
        Calendar dd = Calendar.getInstance();//定义日期实例
        dd.setTime(d1);//设置日期起始时间
        while(dd.getTime().getTime() <= d2.getTime()){//判断是否到结束日期
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String str = sdf.format(dd.getTime());
            result.add(str);
            dd.add(Calendar.DAY_OF_MONTH, 1);//进行当前日期月份加1
        }
        return result;
    }

    public static void main(String[] args) {
//        Date pastDate = DateUtils.getPastDate("2022-05-25", "yyyy-MM-dd");
        Date date = addDate(new Date(), -1);
        System.out.println( formatDate(date,"yyyy-MM-dd HH:mm:ss"));
    }

}
