package com.ruoyi.system.domain.md.enums;

import java.util.HashMap;
import java.util.Map;

public enum OutboxState {
    delete((byte)0,"删除"),send((byte)1,"已发送"),draft((byte)2,"草稿"),
    deleteDraft((byte)-1,"删除草稿"), dump((byte)-2,"真删除"),
    remind((byte)3,"提醒消息");

    private byte code;
    private String text;

    OutboxState(byte code, String text) {
        this.code = code;
        this.text = text;
    }

    public static Map<Byte,OutboxState> maps = null;

    static
    {
        maps = new HashMap<>();
        for(OutboxState it : OutboxState.values())
        {
            maps.put(it.getCode(),it);
        }
    }

    public static OutboxState getByCode(byte code)
    {
        return maps.get(code);
    }

    public byte getCode() {
        return code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

}
