package com.ruoyi.web.controller.other;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.other.*;
import com.ruoyi.system.service.other.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.weaver.loadtime.Aj;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * @author : peter
 * @description: TODO
 * @date : 2024-01-09 16:33
 */
@Api(tags = "其他配置 - 万石大屏配置")
@RestController
@RequestMapping("/api/wsStone")
public class WsStoneController {

    @Autowired
    private WsStoneApplicationService wsStoneApplicationService;
    @Autowired
    private WsStoneBasicService wsStoneBasicService;
    @Autowired
    private WsStoneBiddingService wsStoneBiddingService;
    @Autowired
    private WsStoneCompanyService wsStoneCompanyService;
    @Autowired
    private WsStoneHotService wsStoneHotService;
    @Autowired
    private WsStoneInfoService wsStoneInfoService;
    @Autowired
    private WsStoneIntroduceService wsStoneIntroduceService;
    @Autowired
    private WsStoneMapService wsStoneMapService;
    @Autowired
    private WsStonePartyService wsStonePartyService;
    
    @RequestMapping(value = "/introduce", method = RequestMethod.GET)
    public AjaxResult introduce() {
        try {
            WsStoneIntroduceExample ex = new WsStoneIntroduceExample();
            WsStoneIntroduceExample.Criteria ca = ex.createCriteria();
            List<WsStoneIntroduce> wsStoneIntroduceList = wsStoneIntroduceService.selectByExampleWithBLOBs(ex);
            if (CollectionUtils.isNotEmpty(wsStoneIntroduceList)) {
                return AjaxResult.success(wsStoneIntroduceList.get(0));
            } else {
                return AjaxResult.success(null);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/introduce/add")
    public AjaxResult introduceAdd(@RequestBody WsStoneIntroduce wsStoneIntroduce) {
        wsStoneIntroduce.setId(IdUtil.fastSimpleUUID());
        wsStoneIntroduceService.insertSelective(wsStoneIntroduce);
        return AjaxResult.success("success", wsStoneIntroduce.getId());
    }

    /**
     * 修改
     */
    @PostMapping(value = "/introduce/edit")
    public AjaxResult introduceEdit(@RequestBody WsStoneIntroduce wsStoneIntroduce) {
        wsStoneIntroduceService.updateByPrimaryKeySelective(wsStoneIntroduce);
        return AjaxResult.success();
    }

    /**
     * 详情
     */
    @GetMapping(value = "/introduce/detail/{id}")
    public AjaxResult introduceDetail(@PathVariable("id") String id) {
        return AjaxResult.success(wsStoneIntroduceService.selectByPrimaryKey(id));
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/introduce/delete")
    public AjaxResult introduceDelete(@RequestParam(value = "id") String id) {
        wsStoneIntroduceService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }


    @RequestMapping(value = "/map/page", method = RequestMethod.GET)
    public AjaxResult mapPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                              @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                              @RequestParam(value = "name", required = false) String name) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            WsStoneMapExample ex = new WsStoneMapExample();
            WsStoneMapExample.Criteria ca = ex.createCriteria();
            if (StringUtils.isNotBlank(name)) {
                ca.andNameLike("%" + name + "%");
            }
            ex.setOrderByClause(" create_time asc ");
            List<WsStoneMap> wsStoneMapList = wsStoneMapService.selectByExample(ex);
            PageInfo<WsStoneMap> pageInfo = new PageInfo<>(wsStoneMapList);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    @RequestMapping(value = "/map/List", method = RequestMethod.GET)
    public AjaxResult mapList() {
        try {
            WsStoneMapExample ex = new WsStoneMapExample();
            WsStoneMapExample.Criteria ca = ex.createCriteria();
            ex.setOrderByClause(" create_time asc ");
            List<WsStoneMap> wsStoneMapList = wsStoneMapService.selectByExample(ex);
            return AjaxResult.success(wsStoneMapList);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/map/add")
    public AjaxResult mapAdd(@RequestBody WsStoneMap wsStoneMap) {
        wsStoneMap.setId(IdUtil.fastSimpleUUID());
        wsStoneMap.setCreateTime(DateUtil.formatDateTime(new Date()));
        wsStoneMapService.insertSelective(wsStoneMap);
        return AjaxResult.success("success", wsStoneMap.getId());
    }

    /**
     * 修改
     */
    @PostMapping(value = "/map/edit")
    public AjaxResult mapEdit(@RequestBody WsStoneMap wsStoneMap) {
        wsStoneMapService.updateByPrimaryKeySelective(wsStoneMap);
        return AjaxResult.success(null);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/map/detail/{id}")
    public AjaxResult mapDetail(@PathVariable("id") String id) {
        return AjaxResult.success(wsStoneMapService.selectByPrimaryKey(id));
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/map/delete")
    public AjaxResult mapDelete(@RequestParam(value = "id") String id) {
        wsStoneMapService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }


    @RequestMapping(value = "/basic/List", method = RequestMethod.GET)
    public AjaxResult basicList() {
        try {
            WsStoneBasicExample ex = new WsStoneBasicExample();
            WsStoneBasicExample.Criteria ca = ex.createCriteria();
            ex.setOrderByClause(" create_time asc ");
            List<WsStoneBasic> wsStoneBasicList = wsStoneBasicService.selectByExample(ex);
            return AjaxResult.success(wsStoneBasicList);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/basic/add")
    public AjaxResult basicAdd(@RequestBody WsStoneBasic wsStoneBasic) {
        wsStoneBasic.setId(IdUtil.fastSimpleUUID());
        wsStoneBasic.setCreateTime(DateUtil.formatDateTime(new Date()));
        wsStoneBasicService.insertSelective(wsStoneBasic);
        return AjaxResult.success(wsStoneBasic.getId());
    }

    /**
     * 修改
     */
    @PostMapping(value = "/basic/edit")
    public AjaxResult basicEdit(@RequestBody WsStoneBasic wsStoneBasic) {
        wsStoneBasicService.updateByPrimaryKeySelective(wsStoneBasic);
        return AjaxResult.success(null);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/basic/detail/{id}")
    public AjaxResult basicDetail(@PathVariable("id") String id) {
        return AjaxResult.success(wsStoneBasicService.selectByPrimaryKey(id));
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/basic/delete")
    public AjaxResult basicDelete(@RequestParam(value = "id") String id) {
        wsStoneBasicService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }


    @RequestMapping(value = "/company/page", method = RequestMethod.GET)
    public AjaxResult companyPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                  @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                  @RequestParam(value = "companyName", required = false) String companyName) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            WsStoneCompanyExample ex = new WsStoneCompanyExample();
            WsStoneCompanyExample.Criteria ca = ex.createCriteria();
            if (StringUtils.isNotBlank(companyName)) {
                ca.andCompanyNameLike("%" + companyName + "%");
            }
            ex.setOrderByClause(" sale desc ");
            List<WsStoneCompany> wsStoneCompanyList = wsStoneCompanyService.selectByExample(ex);
            PageInfo<WsStoneCompany> pageInfo = new PageInfo<>(wsStoneCompanyList);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/company/add")
    public AjaxResult companyAdd(@RequestBody WsStoneCompany wsStoneCompany) {
        wsStoneCompany.setId(IdUtil.fastSimpleUUID());
        wsStoneCompany.setCreateTime(DateUtil.formatDateTime(new Date()));
        wsStoneCompanyService.insertSelective(wsStoneCompany);
        return AjaxResult.success(wsStoneCompany.getId());
    }

    /**
     * 修改
     */
    @PostMapping(value = "/company/edit")
    public AjaxResult companyEdit(@RequestBody WsStoneCompany wsStoneCompany) {
        wsStoneCompanyService.updateByPrimaryKeySelective(wsStoneCompany);
        return AjaxResult.success(null);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/company/detail/{id}")
    public AjaxResult companyDetail(@PathVariable("id") String id) {
        return AjaxResult.success(wsStoneCompanyService.selectByPrimaryKey(id));
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/company/delete")
    public AjaxResult companyDelete(@RequestParam(value = "id") String id) {
        wsStoneCompanyService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }


    @RequestMapping(value = "/info/page", method = RequestMethod.GET)
    public AjaxResult infoPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                               @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                               @RequestParam(value = "title", required = false) String title) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            WsStoneInfoExample ex = new WsStoneInfoExample();
            WsStoneInfoExample.Criteria ca = ex.createCriteria();
            if (StringUtils.isNotBlank(title)) {
                ca.andTitleLike("%" + title + "%");
            }
            ex.setOrderByClause(" create_time asc ");
            List<WsStoneInfo> wsStoneInfoList = wsStoneInfoService.selectByExampleWithBLOBs(ex);
            PageInfo<WsStoneInfo> pageInfo = new PageInfo<>(wsStoneInfoList);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/info/add")
    public AjaxResult infoAdd(@RequestBody WsStoneInfo WsStoneInfo) {
        WsStoneInfo.setId(IdUtil.fastSimpleUUID());
        WsStoneInfo.setCreateTime(DateUtil.formatDateTime(new Date()));
        wsStoneInfoService.insertSelective(WsStoneInfo);
        return AjaxResult.success(WsStoneInfo.getId());
    }

    /**
     * 修改
     */
    @PostMapping(value = "/info/edit")
    public AjaxResult infoEdit(@RequestBody WsStoneInfo WsStoneInfo) {
        wsStoneInfoService.updateByPrimaryKeySelective(WsStoneInfo);
        return AjaxResult.success(null);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/info/detail/{id}")
    public AjaxResult infoDetail(@PathVariable("id") String id) {
        return AjaxResult.success(wsStoneInfoService.selectByPrimaryKey(id));
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/info/delete")
    public AjaxResult infoDelete(@RequestParam(value = "id") String id) {
        wsStoneInfoService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }


    @RequestMapping(value = "/hot/page", method = RequestMethod.GET)
    public AjaxResult hotPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                              @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                              @RequestParam(value = "title", required = false) String title) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            WsStoneHotExample ex = new WsStoneHotExample();
            WsStoneHotExample.Criteria ca = ex.createCriteria();
            if (StringUtils.isNotBlank(title)) {
                ca.andTitleLike("%" + title + "%");
            }
            ex.setOrderByClause(" create_time asc ");
            List<WsStoneHot> wsStoneHotList = wsStoneHotService.selectByExampleWithBLOBs(ex);
            PageInfo<WsStoneHot> pageInfo = new PageInfo<>(wsStoneHotList);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/hot/add")
    public AjaxResult hotAdd(@RequestBody WsStoneHot wsStoneHot) {
        wsStoneHot.setId(IdUtil.fastSimpleUUID());
        wsStoneHot.setCreateTime(DateUtil.formatDateTime(new Date()));
        wsStoneHotService.insertSelective(wsStoneHot);
        return AjaxResult.success(wsStoneHot.getId());
    }

    /**
     * 修改
     */
    @PostMapping(value = "/hot/edit")
    public AjaxResult hotEdit(@RequestBody WsStoneHot wsStoneHot) {
        wsStoneHotService.updateByPrimaryKeySelective(wsStoneHot);
        return AjaxResult.success(null);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/hot/detail/{id}")
    public AjaxResult hotDetail(@PathVariable("id") String id) {
        return AjaxResult.success(wsStoneHotService.selectByPrimaryKey(id));
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/hot/delete")
    public AjaxResult hotDelete(@RequestParam(value = "id") String id) {
        wsStoneHotService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }


    @RequestMapping(value = "/party/page", method = RequestMethod.GET)
    public AjaxResult partyPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                @RequestParam(value = "title", required = false) String title) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            WsStonePartyExample ex = new WsStonePartyExample();
            WsStonePartyExample.Criteria ca = ex.createCriteria();
            if (StringUtils.isNotBlank(title)) {
                ca.andTitleLike("%" + title + "%");
            }
            ex.setOrderByClause(" create_time asc ");
            List<WsStoneParty> wsStonePartyList = wsStonePartyService.selectByExampleWithBLOBs(ex);
            PageInfo<WsStoneParty> pageInfo = new PageInfo<>(wsStonePartyList);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/party/add")
    public AjaxResult partyAdd(@RequestBody WsStoneParty wsStoneParty) {
        wsStoneParty.setId(IdUtil.fastSimpleUUID());
        wsStoneParty.setCreateTime(DateUtil.formatDateTime(new Date()));
        wsStonePartyService.insertSelective(wsStoneParty);
        return AjaxResult.success(wsStoneParty.getId());
    }

    /**
     * 修改
     */
    @PostMapping(value = "/party/edit")
    public AjaxResult partyEdit(@RequestBody WsStoneParty wsStoneParty) {
        wsStonePartyService.updateByPrimaryKeySelective(wsStoneParty);
        return AjaxResult.success(null);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/party/detail/{id}")
    public AjaxResult partyDetail(@PathVariable("id") String id) {
        return AjaxResult.success(wsStonePartyService.selectByPrimaryKey(id));
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/party/delete")
    public AjaxResult partyDelete(@RequestParam(value = "id") String id) {
        wsStonePartyService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }


    @RequestMapping(value = "/bidding/page", method = RequestMethod.GET)
    public AjaxResult biddingPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                  @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                  @RequestParam(value = "title", required = false) String title,
                                  @RequestParam(value = "biddingUnit", required = false) String biddingUnit,
                                  @RequestParam(value = "location", required = false) String location) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            WsStoneBiddingExample ex = new WsStoneBiddingExample();
            WsStoneBiddingExample.Criteria ca = ex.createCriteria();
            if (StringUtils.isNotBlank(title)) {
                ca.andTitleLike("%" + title + "%");
            }
            if (StringUtils.isNotBlank(biddingUnit)) {
                ca.andBiddingUnitLike("%" + biddingUnit + "%");
            }
            if (StringUtils.isNotBlank(location)) {
                ca.andLocationLike("%" + location + "%");
            }
            ex.setOrderByClause(" create_time asc ");
            List<WsStoneBidding> wsStoneBiddingList = wsStoneBiddingService.selectByExample(ex);
            PageInfo<WsStoneBidding> pageInfo = new PageInfo<>(wsStoneBiddingList);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/bidding/add")
    public AjaxResult biddingAdd(@RequestBody WsStoneBidding wsStoneBidding) {
        wsStoneBidding.setId(IdUtil.fastSimpleUUID());
        wsStoneBidding.setCreateTime(DateUtil.formatDateTime(new Date()));
        wsStoneBiddingService.insertSelective(wsStoneBidding);
        return AjaxResult.success(wsStoneBidding.getId());
    }

    /**
     * 修改
     */
    @PostMapping(value = "/bidding/edit")
    public AjaxResult biddingEdit(@RequestBody WsStoneBidding wsStoneBidding) {
        wsStoneBiddingService.updateByPrimaryKeySelective(wsStoneBidding);
        return AjaxResult.success(null);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/bidding/detail/{id}")
    public AjaxResult biddingDetail(@PathVariable("id") String id) {
        return AjaxResult.success(wsStoneBiddingService.selectByPrimaryKey(id));
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/bidding/delete")
    public AjaxResult biddingDelete(@RequestParam(value = "id") String id) {
        wsStoneBiddingService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }


    @RequestMapping(value = "/application/page", method = RequestMethod.GET)
    public AjaxResult applicationPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                      @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                      @RequestParam(value = "title", required = false) String title) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            WsStoneApplicationExample ex = new WsStoneApplicationExample();
            WsStoneApplicationExample.Criteria ca = ex.createCriteria();
            if (StringUtils.isNotBlank(title)) {
                ca.andTitleLike("%" + title + "%");
            }
            ex.setOrderByClause(" create_time asc ");
            List<WsStoneApplication> wsStoneApplicationList = wsStoneApplicationService.selectByExampleWithBLOBs(ex);
            PageInfo<WsStoneApplication> pageInfo = new PageInfo<>(wsStoneApplicationList);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/application/add")
    public AjaxResult applicationAdd(@RequestBody WsStoneApplication wsStoneApplication) {
        wsStoneApplication.setId(IdUtil.fastSimpleUUID());
        wsStoneApplication.setCreateTime(DateUtil.formatDateTime(new Date()));
        wsStoneApplicationService.insertSelective(wsStoneApplication);
        return AjaxResult.success(wsStoneApplication.getId());
    }

    /**
     * 修改
     */
    @PostMapping(value = "/application/edit")
    public AjaxResult applicationEdit(@RequestBody WsStoneApplication wsStoneApplication) {
        wsStoneApplicationService.updateByPrimaryKeySelective(wsStoneApplication);
        return AjaxResult.success(null);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/application/detail/{id}")
    public AjaxResult applicationDetail(@PathVariable("id") String id) {
        return AjaxResult.success(wsStoneApplicationService.selectByPrimaryKey(id));
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/application/delete")
    public AjaxResult applicationDelete(@RequestParam(value = "id") String id) {
        wsStoneApplicationService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }


}
