package com.ruoyi.web.controller.lawcase;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.lawcase.CaseSimple;
import com.ruoyi.system.domain.lawcase.CaseSimpleExample;
import com.ruoyi.system.service.lawcase.CaseSimpleService;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description : 简单执法
 */
@Api(tags = "综合执法 - 简单执法")
@RestController
@RequestMapping("/case/simple")
public class CaseSimpleController {

    @Autowired
    private CaseSimpleService caseSimpleService;

    @RequestMapping(value = "list", method = RequestMethod.GET)
    @ResponseBody
    public AjaxResult list(@RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                           @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize, String ajlx, String ay,
                           String kssj, String jssj, String dsr, String createBy, String ylzd1, String createTime) {

        try {
            if (null == pageNum || pageNum <= 0) {
                pageNum = 1;
            }
            if (null == pageSize || pageSize <= 0) {
                pageSize = 10;
            }
            ZQTPageModel<CaseSimple> appPageModel = new ZQTPageModel<>();
            appPageModel.setRecordCount(0);
            appPageModel.setPageCount(0);
            appPageModel.setCurPage(pageNum);
            appPageModel.setItemList(new ArrayList<>());

            CaseSimpleExample example = new CaseSimpleExample();
            CaseSimpleExample.Criteria criteria = example.createCriteria();
            CaseSimpleExample.Criteria criteria1 = example.createCriteria();
            if (StringUtils.isNotEmpty(ay)) {
                criteria.andAyLike("%" + ay + "%");
                criteria1.andAyLike("%" + ay + "%");
            }
            if (StringUtils.isNotEmpty(ajlx)) {
                criteria.andAjlxEqualTo(ajlx);
                criteria1.andAjlxEqualTo(ajlx);
            }
            if (StringUtils.isNotEmpty(kssj)) {
                criteria.andSbsjBetween(kssj, jssj);
                criteria1.andSbsjBetween(kssj, jssj);
            }
            if (StringUtils.isNotEmpty(dsr)) {
                criteria.andDsrFrMcLike("%" + dsr + "%");
                criteria1.andDsrGmXmLike("%" + dsr + "%");
            }
            if (StringUtils.isNotEmpty(createBy)) {
                criteria.andCreateByEqualTo(createBy);
                criteria1.andCreateByEqualTo(createBy);
            }
            if (StringUtils.isNotEmpty(ylzd1)) {
                criteria.andYlzd1EqualTo(ylzd1);
                criteria1.andYlzd1EqualTo(ylzd1);
            }
            if (StringUtils.isNotEmpty(createTime)) {
                criteria.andCreateTimeLike("%" + createTime + "%");
                criteria1.andCreateTimeLike("%" + createTime + "%");
            }
            example.or(criteria1);
            example.setOrderByClause(" create_time desc ");
            int count = caseSimpleService.countByExample(example);
            List<CaseSimple> roles = caseSimpleService.selectByExampleForStartPage(example, pageNum, pageSize);

            appPageModel.setRecordCount(count);
            appPageModel.setPageCount((long) Math.ceil(1.0 * count / pageSize));
            appPageModel.setCurPage(pageNum);
            appPageModel.setItemList(roles);
            return AjaxResult.success(appPageModel);

        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误:" + e.getMessage());
        }
    }

    @RequestMapping(value = "saveCaseSimple", method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult saveCaseSimple(@RequestBody CaseSimple body) {
        try {
            int ret = 0;
            if (StringUtils.isEmpty(body.getId())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String str = sdf.format(new Date());
                String id = UUID.randomUUID().toString();
                body.setId(id);
                body.setCreateTime(str);
                ret = caseSimpleService.insert(body);
            } else {
                ret = caseSimpleService.updateByPrimaryKeySelective(body);
            }
            if (ret > 0) {
                return AjaxResult.success("success", body.getId());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误" + e.getMessage());
        }
        return AjaxResult.error(500, "保存失败");
    }

    @RequestMapping(value = "loadCaseSimple", method = RequestMethod.GET)
    @ResponseBody
    public AjaxResult loadCaseSimple(@RequestParam("id") String id) {
        try {
            CaseSimple roles = caseSimpleService.selectByPrimaryKey(id);
            return AjaxResult.success(roles);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误" + e.getMessage());
        }
    }

    @RequestMapping(value = "delJdzf", method = RequestMethod.GET)
    @ResponseBody
    public AjaxResult delSlAjsldjb(@RequestParam("id") String id) {
        try {
            // 删除简易案件
            int a = caseSimpleService.deleteByStringPrimaryKey(id);
            if (a > 0) {
                return AjaxResult.success();
            }
        } catch (Exception e) {
            return AjaxResult.error(500, "服务器内部错误" + e.getMessage());
        }
        return AjaxResult.error(500, "删除失败");
    }

    // 统计简易案件
    @RequestMapping(value = "countCaseSimple", method = RequestMethod.GET)
    @ResponseBody
    public AjaxResult countCaseSimple(String createBy) {
        try {
            CaseSimpleExample example = new CaseSimpleExample();
            CaseSimpleExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty(createBy)) {
                criteria.andCreateByEqualTo(createBy);
            }
            int a = caseSimpleService.countByExample(example);
            return AjaxResult.success("success", a);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误" + e.getMessage());
        }
    }

    @RequestMapping(value = "dyCaseSimpe", method = RequestMethod.GET)
    @ResponseBody
    public AjaxResult dyCaseSimpe(String id, HttpServletRequest request,
                                  HttpServletResponse response) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (!id.equals("")) {
            CaseSimple roles = caseSimpleService.selectByPrimaryKey(id);
            map.put("jdzf", roles);
        } else {
            return AjaxResult.error(500, "ID不存在,无此表信息");
        }
        return AjaxResult.success(map);
    }
}