package com.ruoyi.system.domain.qcc.factory;

import com.ruoyi.system.domain.qcc.enums.EsearchTypeEnum;
import com.ruoyi.system.service.grid.qcc.ISearch;
import com.ruoyi.system.service.grid.qcc.impl.QccSearch;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
public class EsearchFactory {
    private static Map<EsearchTypeEnum, ISearch> handlerMap = null;
    static {
        handlerMap = new HashMap<>();
        handlerMap.put(EsearchTypeEnum.qcc,new QccSearch());

    }
    public ISearch getHandler(EsearchTypeEnum typeEnum) {
        return handlerMap.get(typeEnum);
    }
}
