package com.ruoyi.web.controller.task;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.task.TkRoundMatter;
import com.ruoyi.system.domain.task.TkRoundMatterExample;
import com.ruoyi.system.service.task.TkRoundMatterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "工单 巡查 事项")
@RestController
@RequestMapping("/api/task/roundMatter")
public class RoundMatterController {
    @Autowired
    TkRoundMatterService tkRoundMatterService;

    @ApiOperation("列表")
    @GetMapping
    @ResponseBody
    public String getList(@RequestParam(required = false, value = "pageNum", defaultValue = "1") int pageNum,
                          @RequestParam(required = false, value = "pageSize", defaultValue = "1000") int pageSize,
                          @RequestParam(required = false, value = "subTaskId") String subTaskId,
                          @RequestParam(required = false, value = "comTaskId") String comTaskId,
                          @RequestParam(required = false, value = "matterId") String matterId,
                          @RequestParam(required = false, value = "type") String type,
                          @RequestParam(required = false, value = "name") String name
    ) {
        TkRoundMatterExample tkRoundMatterExample = new TkRoundMatterExample();
        TkRoundMatterExample.Criteria criteria = tkRoundMatterExample.createCriteria();

        tkRoundMatterExample.setOrderByClause("create_time desc");
        if (StringUtils.isNotBlank(subTaskId)) {
            criteria.andSubTaskIdEqualTo(subTaskId);
        }
        if (StringUtils.isNotBlank(comTaskId)) {
            criteria.andComTaskIdEqualTo(comTaskId);
        }
        if (StringUtils.isNotBlank(matterId)) {
            criteria.andMatterIdEqualTo(matterId);
        }
        if (StringUtils.isNotBlank(type)) {
            criteria.andTypeEqualTo(type);
        }
        if (StringUtils.isNotBlank(name)) {
            criteria.andNameLike("%" + name + "%");
        }

        PageHelper.startPage(pageNum, pageSize);
        List<TkRoundMatter> tkRoundMatterList = tkRoundMatterService.selectByExample(tkRoundMatterExample);
        int recordCount = tkRoundMatterService.countByExample(tkRoundMatterExample);
        
        // 分页
        ZQTPageModel zqtongPageListResult = new ZQTPageModel();
        zqtongPageListResult.setItemList(tkRoundMatterList);
        //当前页
        zqtongPageListResult.setCurPage(recordCount == 0 ? 0 : pageNum);
        //总页数
        int totalPageNum = (recordCount + pageSize - 1) / pageSize;
        zqtongPageListResult.setPageCount(totalPageNum);
        //总记录数
        zqtongPageListResult.setRecordCount(recordCount);

        return JSON.toJSONString(AjaxResult.build(200, "success", zqtongPageListResult));
    }

    @ApiOperation("异常开关")
    @RequestMapping(value = "unusual", method = RequestMethod.PUT)
    @ResponseBody
    public String unusual(String id, boolean unusual) {
        TkRoundMatter matter = tkRoundMatterService.selectByPrimaryKey(id);
//        有无异常   有：true、无：false
        matter.setUnusual(unusual);
        // 异常开——>上报2/查看3
        if (unusual) {
//            comTaskID空就是上报 else 查看3
            if (StringUtils.isBlank(matter.getComTaskId())) {
                matter.setAction("2");
            } else {
                matter.setAction("3");
            }
        } else {    // 异常关——>备注0/看备注1
//            没备注自然要加备注
            if (StringUtils.isBlank(matter.getRemark())) {
                matter.setAction("0");
            } else {
                matter.setAction("1");
            }
        }
        int result = tkRoundMatterService.updateByPrimaryKey(matter);
        if (result == 0) {
            return JSON.toJSONString(AjaxResult.build(500, "false"));
        }
        return JSON.toJSONString(AjaxResult.build(200, "success",matter.getAction()));
    }

    @ApiOperation("加备注")
    @RequestMapping(value = "remark", method = RequestMethod.PUT)
    @ResponseBody
    public String addRemark(String id, String remark) {
        TkRoundMatter matter = tkRoundMatterService.selectByPrimaryKey(id);
        matter.setRemark(remark);
        matter.setAction("1");
        int result = tkRoundMatterService.updateByPrimaryKey(matter);
        if (result == 0) {
            return JSON.toJSONString(AjaxResult.build(500, "false"));
        }
        return JSON.toJSONString(AjaxResult.build(200, "success"));
    }

    @ApiOperation("看备注")
    @RequestMapping(value = "remark", method = RequestMethod.GET)
    @ResponseBody
    public String remark(String id) {
        TkRoundMatter matter = tkRoundMatterService.selectByPrimaryKey(id);
        return JSON.toJSONString(AjaxResult.build(200, "success",matter.getRemark()));
    }

    @ApiOperation("加日常任务")
    @RequestMapping(value = "comTask", method = RequestMethod.PUT)
    @ResponseBody
    public String comTask(String id, String comTaskId) {
        TkRoundMatter matter = tkRoundMatterService.selectByPrimaryKey(id);
        matter.setComTaskId(comTaskId);
        matter.setAction("3");
        int result = tkRoundMatterService.updateByPrimaryKey(matter);
        if (result == 0) {
            return JSON.toJSONString(AjaxResult.build(500, "false"));
        }
        return JSON.toJSONString(AjaxResult.build(200, "success"));
    }


}
