package com.ruoyi.common.core.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.ruoyi.common.core.domain.entity.SysUser;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * * Author: brenda
 * * 2024/7/23
 **/
public class DeptUserTree implements Serializable {

    private String id;

    /** 节点名称 */
    private String label;

    private int count;

    private String avatar;

    private boolean isDep = true;

    /** 子节点 */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<DeptUserTree> children;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel()
    {
        return label;
    }

    public void setLabel(String label)
    {
        this.label = label;
    }

    public List<DeptUserTree> getChildren()
    {
        return children;
    }

    public void setChildren(List<DeptUserTree> children)
    {
        this.children = children;
    }

    public boolean isDep() {
        return isDep;
    }

    public void setIsDep(boolean isDep) {
        this.isDep = isDep;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setDep(boolean dep) {
        isDep = dep;
    }
}
