package com.ruoyi.web.controller.other;

import com.alibaba.fastjson2.JSON;
import com.github.pagehelper.PageHelper;
import com.ruoyi.common.annotation.Anonymous;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.domain.other.BsCommonExample;
import com.ruoyi.system.service.other.BsCommonService;
import com.ruoyi.system.domain.other.vo.BsCommonVO;
import com.ruoyi.system.service.other.BsCommonFacadeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Auther: hxc
 * @Date: 2019/6/18 0028 14:09
 * @Description: 数据字典
 */
@Api(tags = "基本配置 - 数据字典")
@RestController
@RequestMapping("/api/bsCommon")
public class BsCommonController extends BaseController {

    @Autowired
    private BsCommonFacadeService commonService;

    @Autowired
    private BsCommonService bsCommonService;

    @ApiOperation("列表")
    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ResponseBody
    public TableDataInfo getCommons(@RequestBody BsCommonVO bsCommonVO) {
        PageHelper.startPage(bsCommonVO.getPageNum(),bsCommonVO.getPageSize());
        BsCommonExample example = new BsCommonExample();
        BsCommonExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(bsCommonVO.getParentId())) {
            criteria.andParentIdEqualTo(bsCommonVO.getParentId());
        }
        example.setOrderByClause(" sort + 0 asc ");
        List<BsCommon> list = bsCommonService.selectByExample(example);
        return getDataTable(list);
    }

    @ApiOperation("删除")
    @RequestMapping(value = "", method = RequestMethod.DELETE)
    @ResponseBody
    public String delete(@RequestBody BsCommon body) {
        try {
            return commonService.commit(body, "delete");
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.error(500, "服务器内部错误"));
        }
    }

    @ApiOperation("创建")
    @RequestMapping(value = "", method = RequestMethod.POST)
    @ResponseBody
    public String insert(@RequestBody BsCommon body) {
        try {
            return commonService.commit(body, "insert");
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.error(500, "服务器内部错误"));
        }
    }

    @ApiOperation("更新")
    @RequestMapping(value = "", method = RequestMethod.PATCH)
    @ResponseBody
    public String update(@RequestBody BsCommon body) {
        try {
            return commonService.commit(body, "update");
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.error(500, "服务器内部错误"));
        }
    }

    @ApiOperation("树结构")
    @RequestMapping(value = "/getTreeNode", method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult getTreeNode(@RequestBody BsCommonVO bsCommonVO) {
        try {
            return commonService.getTreeNode(bsCommonVO);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    @Anonymous
    @ApiOperation("获取网格列表")
    @RequestMapping(value = "/getWgdxList", method = RequestMethod.GET)
    @ResponseBody
    public String getWgdxList(@RequestParam(name = "code") String code) {
        try {
            List<BsCommon> wgdxList = bsCommonService.getWgdxList(code);
            return JSON.toJSONString(AjaxResult.success(wgdxList));
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.error(500, "服务器内部错误"));
        }
    }
}
