package com.ruoyi.system.service.other.impl;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.other.MapEntity;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.mapper.other.MapEntityMapper;
import com.ruoyi.system.service.other.MapEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class MapEntityServiceImpl implements MapEntityService {

    @Autowired
    private MapEntityMapper mapEntityMapper;

    @Autowired
    private GridRegionMapper gridRegionMapper;

    @Override
    public List<MapEntity> getAllMapEntitiesByLevel(String level) {
//        QueryWrapper<MapEntity> queryWrapper = new QueryWrapper<>();
//        if(level!=null&& !level.isEmpty()){
//            queryWrapper.eq("entity_level", level);
//        }
//        return mapEntityMapper.selectList(queryWrapper);
        GridRegionExample example = new GridRegionExample();
        GridRegionExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo("1");
        if(level == null || level.isEmpty()) {
            return null;
        }
        criteria.andLevelEqualTo(level);
        criteria.andWgTypeEqualTo("1");

        List<GridRegion> gridRegionList = gridRegionMapper.selectByExample(example);
        List<MapEntity> mapEntityList = new ArrayList<>();
        for (GridRegion gridRegion : gridRegionList) {
            MapEntity mapEntity = new MapEntity();
            mapEntity.setId(gridRegion.getId());
            mapEntity.setType(gridRegion.getWgType());
            mapEntity.setEntityCode(gridRegion.getWgCode());
            mapEntity.setEntityLevel(new Integer(gridRegion.getLevel()));
            mapEntity.setEntityName(gridRegion.getWgName());
            mapEntity.setParentEntity(gridRegion.getWgParentId());
            mapEntity.setEntityScope(gridRegion.getWgArea());
            mapEntity.setCoordinateAddress(gridRegion.getWgCentreCoordinate());
            mapEntity.setValid(1);
            mapEntity.setQrCode(gridRegion.getWgPrincipal());
            mapEntityList.add(mapEntity);
        }
        return mapEntityList;
    }

    @Override
    public MapEntity getMapEntityById(String id) {
        return mapEntityMapper.selectById(id);
    }

    @Override
    public MapEntity updateMapEntity(String id, MapEntity mapEntity) {
        mapEntity.setId(id);
        mapEntityMapper.updateById(mapEntity);
        return mapEntity;
    }

    @Override
    public void deleteMapEntity(String id) {
        mapEntityMapper.deleteById(id);
    }

    @Override
    public MapEntity addMapEntityById(MapEntity mapEntity) {
        mapEntity.setId(UUID.randomUUID().toString());
        mapEntityMapper.insert(mapEntity);
        return mapEntity;
    }
}