package com.ruoyi.system.service.publicservice.impl;

import com.ruoyi.common.constant.BsConstants;
import com.ruoyi.common.core.redis.PublicServiceRedisCache;
import com.ruoyi.common.utils.BsUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.sql.Query;
import com.ruoyi.system.domain.publicservice.TPublicServiceDemand;
import com.ruoyi.system.mapper.publicservice.TPublicServiceDemandMapper;
import com.ruoyi.system.service.publicservice.TPublicServiceDemandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 需求
 * @author wujm<wujm@eazytec.com>
 */
@Service
public class TPublicServiceDemandServiceImpl implements TPublicServiceDemandService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Resource
	private TPublicServiceDemandMapper tPublicServiceDemandMapper;

	@Autowired
	private PublicServiceRedisCache redisCache;

	/** 基础功能不要直接写实现 */
	/**
	* 列表
	* @return
	*/
	private List<TPublicServiceDemand> list(TPublicServiceDemand tPublicServiceDemand) {
		return tPublicServiceDemandMapper.list(tPublicServiceDemand);
	}

	/**
	* 查询
	* @param id
	*/
	private TPublicServiceDemand getObjectById(Long id) {
		Query query = new Query();
		query.put("demandId",id);
		return tPublicServiceDemandMapper.getObjectById(query);
	}

    /**
     * 分页查询
     * @param tPublicServiceDemand
     * @return
     */
	@Override
	public List<TPublicServiceDemand> listTPublicServiceDemand(TPublicServiceDemand tPublicServiceDemand) {
		return this.list(tPublicServiceDemand);
	}

    /**
     * 新增
     * @param tPublicServiceDemand
     * @return
     */
	@Override
	public int saveTPublicServiceDemand(TPublicServiceDemand tPublicServiceDemand) {
		tPublicServiceDemand.setDemandCode(this.getMaxNum());
		return tPublicServiceDemandMapper.save(tPublicServiceDemand);
	}

    /**
     * 根据id查询
     * @param id
     * @return
     */
	@Override
	public TPublicServiceDemand getTPublicServiceDemandById(Long id) {
		return this.getObjectById(id);
	}

    /**
     * 修改
     * @param tPublicServiceDemand
     * @return
     */
	@Override
	public int updateTPublicServiceDemand(TPublicServiceDemand tPublicServiceDemand) {
		return tPublicServiceDemandMapper.update(tPublicServiceDemand);
	}

    /**
     * 删除
     * @param ids
     * @return
     */
	@Override
	public int batchRemove(Long[] ids) {
		int count = 0;
		for(Long id:ids) {
			count += tPublicServiceDemandMapper.remove(id);
		}
		return count;
	}

	@Override
	public String getMaxNum(){
		String numKey = BsUtils.getBsCacheKey(String.format("%s%s", BsConstants.CACHE_KEY_DEMAND_NO));
		String num = "";
		if (!redisCache.keys().exists(numKey)) {
			TPublicServiceDemand demand = new TPublicServiceDemand();
			demand = tPublicServiceDemandMapper.getMaxNo(demand);

			if(StringUtils.isNull(demand.getDemandCode())){
				num = "00001";
			}else{
				num = demand.getDemandCode().substring(2,7);
			}
			redisCache.strings().setnx(numKey,Integer.parseInt(num));
		}
		redisCache.keys().expire(numKey, 2, TimeUnit.DAYS);
		Long no = redisCache.strings().incrBy(numKey, 1L);
		return "FXQZ"+ BsUtils.formatMindNo(no,5);

	}
}
