package com.ruoyi.system.domain.publicservice;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 资源
 * @author wujm<wujm@eazytec.com>
 */
public class TPublicServiceResource implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * 主键id
	 */
	private Long resId;
	
	/**
	 * 资源类型
	 */
	private String resType;
	
	/**
	 * 资源名称
	 */
	private String resName;
	
	/**
	 * 资源地址
	 */
	private String resAddress;
	
	/**
	 * 资源描述
	 */
	private String resDesc;
	
	/**
	 * 价格类型
	 */
	private String resPriceType;
	
	/**
	 * 价格
	 */
	private String resPrice;
	
	/**
	 * 价格最高
	 */
	private String resPriceEnd;
	
	/**
	 * 资源状态 0 未审核 1通过 2不通过
	 */
	private String resStatus;
	
	/**
	 * 姓名
	 */
	private String resOwner;
	
	/**
	 * 联系方式
	 */
	private String resPhone;

	/**
	 * 是否有效1 有效 0 无效
	 */
	private Integer valid;
	
	/**
	 * 
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date createTime;
	
	/**
	 * 
	 */

	private String createBy;
	
	/**
	 * 
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date updateTime;
	
	/**
	 * 
	 */
	private String updateBy;
	
	/**
	 * 资源编号
	 */
	private String resCode;
	
	/**
	 * 类型 1 资源 2 需求
	 */
	private String typeName;

	private String orderColumn;

	private String orderType;

	private List<TOtherappAttachment> attachmentList;

	/**
	 * 经度
	 */
	private String longitude;

	/**
	 * 纬度
	 */
	private String latitude;
	/**
	 * 头像
	 */
	private String headProfile;


	public List<TOtherappAttachment> getAttachmentList() {
		return attachmentList;
	}

	public void setAttachmentList(List<TOtherappAttachment> attachmentList) {
		this.attachmentList = attachmentList;
	}

	public TPublicServiceResource() {
		super();
	}

	public String getHeadProfile() {
		return headProfile;
	}

	public void setHeadProfile(String headProfile) {
		this.headProfile = headProfile;
	}

	public String getLongitude() {
		return longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getLatitude() {
		return latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public String getOrderColumn() {
		return orderColumn;
	}

	public void setOrderColumn(String orderColumn) {
		this.orderColumn = orderColumn;
	}

	public String getOrderType() {
		return orderType;
	}

	public void setOrderType(String orderType) {
		this.orderType = orderType;
	}

	/**
     * setter for resId
     * @param resId
     */
	public void setResId(Long resId) {
		this.resId = resId;
	}

    /**
     * getter for resId
     */
	public Long getResId() {
		return resId;
	}
	
    /**
     * setter for resType
     * @param resType
     */
	public void setResType(String resType) {
		this.resType = resType;
	}

    /**
     * getter for resType
     */
	public String getResType() {
		return resType;
	}
	
    /**
     * setter for resName
     * @param resName
     */
	public void setResName(String resName) {
		this.resName = resName;
	}

    /**
     * getter for resName
     */
	public String getResName() {
		return resName;
	}
	
    /**
     * setter for resAddress
     * @param resAddress
     */
	public void setResAddress(String resAddress) {
		this.resAddress = resAddress;
	}

    /**
     * getter for resAddress
     */
	public String getResAddress() {
		return resAddress;
	}
	
    /**
     * setter for resDesc
     * @param resDesc
     */
	public void setResDesc(String resDesc) {
		this.resDesc = resDesc;
	}

    /**
     * getter for resDesc
     */
	public String getResDesc() {
		return resDesc;
	}
	
    /**
     * setter for resPriceType
     * @param resPriceType
     */
	public void setResPriceType(String resPriceType) {
		this.resPriceType = resPriceType;
	}

    /**
     * getter for resPriceType
     */
	public String getResPriceType() {
		return resPriceType;
	}
	
    /**
     * setter for resPrice
     * @param resPrice
     */
	public void setResPrice(String resPrice) {
		this.resPrice = resPrice;
	}

    /**
     * getter for resPrice
     */
	public String getResPrice() {
		return resPrice;
	}
	
    /**
     * setter for resPriceEnd
     * @param resPriceEnd
     */
	public void setResPriceEnd(String resPriceEnd) {
		this.resPriceEnd = resPriceEnd;
	}

    /**
     * getter for resPriceEnd
     */
	public String getResPriceEnd() {
		return resPriceEnd;
	}
	
    /**
     * setter for resStatus
     * @param resStatus
     */
	public void setResStatus(String resStatus) {
		this.resStatus = resStatus;
	}

    /**
     * getter for resStatus
     */
	public String getResStatus() {
		return resStatus;
	}
    /**
     * setter for resOwner
     * @param resOwner
     */
	public void setResOwner(String resOwner) {
		this.resOwner = resOwner;
	}

    /**
     * getter for resOwner
     */
	public String getResOwner() {
		return resOwner;
	}
	
    /**
     * setter for resPhone
     * @param resPhone
     */
	public void setResPhone(String resPhone) {
		this.resPhone = resPhone;
	}

    /**
     * getter for resPhone
     */
	public String getResPhone() {
		return resPhone;
	}

    /**
     * setter for valid
     * @param valid
     */
	public void setValid(Integer valid) {
		this.valid = valid;
	}

    /**
     * getter for valid
     */
	public Integer getValid() {
		return valid;
	}
	
    /**
     * setter for createTime
     * @param createTime
     */
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

    /**
     * getter for createTime
     */
	public Date getCreateTime() {
		return createTime;
	}
	
    /**
     * setter for createBy
     * @param createBy
     */
	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

    /**
     * getter for createBy
     */
	public String getCreateBy() {
		return createBy;
	}
	
    /**
     * setter for updateTime
     * @param updateTime
     */
	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

    /**
     * getter for updateTime
     */
	public Date getUpdateTime() {
		return updateTime;
	}
	
    /**
     * setter for updateBy
     * @param updateBy
     */
	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}

    /**
     * getter for updateBy
     */
	public String getUpdateBy() {
		return updateBy;
	}
	
    /**
     * setter for resCode
     * @param resCode
     */
	public void setResCode(String resCode) {
		this.resCode = resCode;
	}

    /**
     * getter for resCode
     */
	public String getResCode() {
		return resCode;
	}
	
    /**
     * setter for typeName
     * @param typeName
     */
	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

    /**
     * getter for typeName
     */
	public String getTypeName() {
		return typeName;
	}
	
}
