package com.ruoyi.party.service.impl;

import com.ruoyi.common.annotation.DataSource;
import com.ruoyi.common.enums.DataSourceType;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.party.domain.ExcellentParty;
import com.ruoyi.party.domain.PartyOrganization;
import com.ruoyi.party.mapper.ExcellentPartyMapper;
import com.ruoyi.party.mapper.PartyOrganizationMapper;
import com.ruoyi.party.service.api.IExcellentPartyService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 优秀党组织Service业务层处理
 * 
 * @author ruoyi
 * @date 2024-05-20
 */
@Service
@DataSource(value = DataSourceType.SLAVE)
public class ExcellentPartyServiceImpl implements IExcellentPartyService
{
    @Autowired
    private ExcellentPartyMapper excellentPartyMapper;

    @Autowired
    private PartyOrganizationMapper partyOrganizationMapper;

    /**
     * 查询优秀党组织
     *
     * @param id 优秀党组织主键
     * @return 优秀党组织
     */
    @Override
    public ExcellentParty selectExcellentPartyById(String id)
    {
        ExcellentParty excellentParty = excellentPartyMapper.selectExcellentPartyById(id);
        if(StringUtils.isNotBlank(excellentParty.getPartyId())){
            PartyOrganization partyOrganization = partyOrganizationMapper.selectById(Long.parseLong(excellentParty.getPartyId()));
            excellentParty.setDzzmc(partyOrganization == null?"":partyOrganization.getDzzmc());
        }
        return excellentParty;
    }

    /**
     * 查询优秀党组织列表
     * 
     * @param excellentParty 优秀党组织
     * @return 优秀党组织
     */
    @Override
    public List<ExcellentParty> selectExcellentPartyList(ExcellentParty excellentParty)
    {
        return excellentPartyMapper.selectExcellentPartyList(excellentParty);
    }

    @Override
    public List<ExcellentParty> convertData(List<ExcellentParty> partyList) {
        if(CollectionUtils.isNotEmpty(partyList)){
            partyList.forEach(e ->{
                if(StringUtils.isNotBlank(e.getPartyId())){
                    PartyOrganization partyOrganization = partyOrganizationMapper.selectById(Long.parseLong(e.getPartyId()));
                    e.setDzzmc(partyOrganization == null?"":partyOrganization.getDzzmc());
                }
            });
        }
        return partyList;
    }

    /**
     * 新增优秀党组织
     * 
     * @param excellentParty 优秀党组织
     * @return 结果
     */
    @Override
    public int insertExcellentParty(ExcellentParty excellentParty)
    {
        excellentParty.setCreateTime(DateUtils.getNowDate());
        return excellentPartyMapper.insertExcellentParty(excellentParty);
    }

    /**
     * 修改优秀党组织
     * 
     * @param excellentParty 优秀党组织
     * @return 结果
     */
    @Override
    public int updateExcellentParty(ExcellentParty excellentParty)
    {
        excellentParty.setUpdateTime(DateUtils.getNowDate());
        return excellentPartyMapper.updateExcellentParty(excellentParty);
    }

    /**
     * 批量删除优秀党组织
     * 
     * @param ids 需要删除的优秀党组织主键
     * @return 结果
     */
    @Override
    public int deleteExcellentPartyByIds(String[] ids)
    {
        return excellentPartyMapper.deleteExcellentPartyByIds(ids);
    }

    /**
     * 删除优秀党组织信息
     * 
     * @param id 优秀党组织主键
     * @return 结果
     */
    @Override
    public int deleteExcellentPartyById(String id)
    {
        return excellentPartyMapper.deleteExcellentPartyById(id);
    }


    @Override
    public String getGoodPartyOrgCounts(Integer year, String beginDate) {
        return excellentPartyMapper.getGoodPartyOrgCounts(year, beginDate);
    }
}
