package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.ClickNumber;
import com.ruoyi.party.service.api.IClickNumberService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 点击次数Controller
 * 
 * @author ruoyi
 * @date 2024-05-24
 */
@Api(tags = "党建-点击次数")
@RestController
@RequestMapping("/api/party/clickNumber")
public class ClickNumberController extends BaseController
{
    @Autowired
    private IClickNumberService clickNumberService;

    /**
     * 查询点击次数列表
     */

    @GetMapping("/list")
    public TableDataInfo list(ClickNumber clickNumber)
    {
        startPage();
        List<ClickNumber> list = clickNumberService.selectClickNumberList(clickNumber);
        return getDataTable(list);
    }

    /**
     * 导出点击次数列表
     */

    @Log(title = "点击次数", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ClickNumber clickNumber)
    {
        List<ClickNumber> list = clickNumberService.selectClickNumberList(clickNumber);
        ExcelUtil<ClickNumber> util = new ExcelUtil<ClickNumber>(ClickNumber.class);
        util.exportExcel(response, list, "点击次数数据");
    }

    /**
     * 获取点击次数详细信息
     */

    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(clickNumberService.selectClickNumberById(id));
    }

    /**
     * 新增点击次数
     */

    @Log(title = "点击次数", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ClickNumber clickNumber)
    {
        return toAjax(clickNumberService.insertClickNumber(clickNumber));
    }

    /**
     * 修改点击次数
     */

    @Log(title = "点击次数", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ClickNumber clickNumber)
    {
        return toAjax(clickNumberService.updateClickNumber(clickNumber));
    }

    /**
     * 删除点击次数
     */

    @Log(title = "点击次数", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(clickNumberService.deleteClickNumberByIds(ids));
    }

    /**
     * 统计点击次数
     */
    @GetMapping("/statisticsClickFrequency/{type}/{businessKey}")
    public AjaxResult statisticsClickFrequency(@PathVariable("type") String type, @PathVariable("businessKey") String businessKey) {
        return AjaxResult.success(clickNumberService.getClickNumberStatistics(type, businessKey));
    }
}
