package com.ruoyi.web.controller.publicservice;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.publicservice.TPublicServiceIfind;
import com.ruoyi.system.domain.publicservice.vo.PSTkCommonTaskVO;
import com.ruoyi.system.domain.task.TkCommonTask;
import com.ruoyi.system.service.publicservice.TPublicServiceIfindService;
import com.ruoyi.system.service.task.TaskService;
import io.swagger.annotations.Api;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 公共服务 我发现表
 * @author wujm<wujm@eazytec.com>
 */
@Api(tags = "公共服务-我发现")
@RestController
@RequestMapping("/api/publicservice/iFind")
public class TPublicServiceIfindController extends BaseController {
	
	@Autowired
	private TPublicServiceIfindService tPublicServiceIfindService;

	@Autowired
	private TaskService taskService;

	@GetMapping(value = "/getMaxNo")
	public AjaxResult getMaxNo() {
		return AjaxResult.success(tPublicServiceIfindService.getMaxNum());
	}
	
	/**
	 * 列表
	 * @param tPublicServiceIfind
	 * @return
	 */
	@GetMapping()
	public TableDataInfo list(TPublicServiceIfind tPublicServiceIfind) {
		startPage();
		return getDataTable(tPublicServiceIfindService.listTPublicServiceIfind(tPublicServiceIfind));
	}
		
	/**
	 * 新增
	 * @param tPublicServiceIfind
	 * @return
	 */
	@Log(title = "新增公共服务 我发现表", businessType = BusinessType.INSERT)
	@PostMapping()
	public AjaxResult save(@RequestBody TPublicServiceIfind tPublicServiceIfind) {
		tPublicServiceIfind.setCreateBy(getUserId());
		tPublicServiceIfindService.saveIfind(tPublicServiceIfind);
		return AjaxResult.success();
	}
	
	/**
	 * 根据id查询详情
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/{id}")
	public AjaxResult getById(@PathVariable("id") Long id) {
		return AjaxResult.success(tPublicServiceIfindService.getIfindById(id));
	}
	
	/**
	 * 修改
	 * @param tPublicServiceIfind
	 * @return
	 */
	@Log(title = "修改公共服务 我发现表", businessType = BusinessType.UPDATE)
	@PutMapping
	public AjaxResult update(@RequestBody TPublicServiceIfind tPublicServiceIfind) {
		tPublicServiceIfind.setUpdateBy(getUserId());
		tPublicServiceIfindService.updateIfind(tPublicServiceIfind, getUsername());
		return AjaxResult.success();
	}
	
	/**
	 * 删除
	 * @param ids
	 * @return
	 */
	@Log(title = "删除公共服务 我发现表", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete")
	public AjaxResult batchRemove(@RequestBody Long[] ids) {
		tPublicServiceIfindService.batchRemove(ids);
		return AjaxResult.success();
	}


	/**
	 * 转工单
	 *
	 * @param tkCommonTask
	 * @return
	 */
	@RequestMapping(value = "/transferTask", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult add(@RequestBody PSTkCommonTaskVO tkCommonTask) {
		if(null == tkCommonTask.getFindOrDiscussId()){
			throw  new ServiceException("我发现id未传");
		}

        TPublicServiceIfind ifind = tPublicServiceIfindService.getIfindById(tkCommonTask.getFindOrDiscussId());

        if(null == ifind){
            throw new ServiceException("我发现记录不存在");
        }
		TkCommonTask task = new TkCommonTask();
		BeanUtils.copyProperties(tkCommonTask, task);
		task.setFormId(tkCommonTask.getFindOrDiscussId().toString());
		//工单来源（传对应数字） 1中心指派、2领导交办 、10事件上报、11民意收集、12隐患整改、网格上报（comefrom为null的）
		task.setComeFrom(10);
		//优先级（传对应数字）：0普通、1重要、2紧急
		task.setPriorityType(0);
		task.setNum(tkCommonTask.getFindCode());
		String projectId = taskService.add(task);
		if(StringUtils.isEmpty(projectId)){
			throw new ServiceException("转工单失败：未能获取工单id");
		}
		ifind.setFindId(tkCommonTask.getFindOrDiscussId());
		ifind.setProjectId(projectId);
        ifind.setGenTask("1");
        ifind.setFindResult("3");
        ifind.setProjectStatus("处理中");
        ifind.setProjectName(tkCommonTask.getTkName());
		int result = tPublicServiceIfindService.updateTPublicServiceIfind(ifind);

		return toAjax(result);
	}
}
