/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.interceptor.InterceptorProcessor;
import com.alibaba.bytekit.asm.interceptor.parser.DefaultInterceptorClassParser;
import com.alibaba.bytekit.asm.location.Location;
import com.alibaba.bytekit.asm.location.LocationType;
import com.alibaba.bytekit.asm.location.MethodInsnNodeWare;
import com.alibaba.bytekit.asm.location.filter.GroupLocationFilter;
import com.alibaba.bytekit.asm.location.filter.InvokeCheckLocationFilter;
import com.alibaba.bytekit.asm.location.filter.InvokeContainLocationFilter;
import com.alibaba.bytekit.asm.location.filter.LocationFilter;
import com.alibaba.bytekit.utils.AsmOpUtils;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.ClassNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.AdviceListenerManager;
import com.taobao.arthas.core.advisor.SpyImpl;
import com.taobao.arthas.core.advisor.SpyInterceptors;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.util.ArthasCheckUtils;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.FileUtils;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import java.arthas.SpyAPI;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class Enhancer
implements ClassFileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(Enhancer.class);
    private final AdviceListener listener;
    private final boolean isTracing;
    private final boolean skipJDKTrace;
    private final Matcher classNameMatcher;
    private final Matcher classNameExcludeMatcher;
    private final Matcher methodNameMatcher;
    private final EnhancerAffect affect;
    private Set<Class<?>> matchingClasses = null;
    private static final Map<Class<?>, Object> classBytesCache = new WeakHashMap();
    private static SpyImpl spyImpl = new SpyImpl();

    public Enhancer(AdviceListener listener, boolean isTracing, boolean skipJDKTrace, Matcher classNameMatcher, Matcher classNameExcludeMatcher, Matcher methodNameMatcher) {
        this.listener = listener;
        this.isTracing = isTracing;
        this.skipJDKTrace = skipJDKTrace;
        this.classNameMatcher = classNameMatcher;
        this.classNameExcludeMatcher = classNameExcludeMatcher;
        this.methodNameMatcher = methodNameMatcher;
        this.affect = new EnhancerAffect();
        this.affect.setListenerId(listener.id());
    }

    @Override
    public byte[] transform(ClassLoader inClassLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            try {
                if (inClassLoader != null) {
                    inClassLoader.loadClass(SpyAPI.class.getName());
                }
            }
            catch (Throwable e) {
                logger.error("the classloader can not load SpyAPI, ignore it. classloader: {}, className: {}", inClassLoader.getClass().getName(), className, e);
                return null;
            }
            if (this.matchingClasses != null && !this.matchingClasses.contains(classBeingRedefined)) {
                return null;
            }
            ClassNode classNode = new ClassNode(589824);
            ClassReader classReader = AsmUtils.toClassNode(classfileBuffer, classNode);
            classNode = AsmUtils.removeJSRInstructions(classNode);
            DefaultInterceptorClassParser defaultInterceptorClassParser = new DefaultInterceptorClassParser();
            ArrayList<InterceptorProcessor> interceptorProcessors = new ArrayList<InterceptorProcessor>();
            interceptorProcessors.addAll(defaultInterceptorClassParser.parse(SpyInterceptors.SpyInterceptor1.class));
            interceptorProcessors.addAll(defaultInterceptorClassParser.parse(SpyInterceptors.SpyInterceptor2.class));
            interceptorProcessors.addAll(defaultInterceptorClassParser.parse(SpyInterceptors.SpyInterceptor3.class));
            if (this.isTracing) {
                if (!this.skipJDKTrace) {
                    interceptorProcessors.addAll(defaultInterceptorClassParser.parse(SpyInterceptors.SpyTraceInterceptor1.class));
                    interceptorProcessors.addAll(defaultInterceptorClassParser.parse(SpyInterceptors.SpyTraceInterceptor2.class));
                    interceptorProcessors.addAll(defaultInterceptorClassParser.parse(SpyInterceptors.SpyTraceInterceptor3.class));
                } else {
                    interceptorProcessors.addAll(defaultInterceptorClassParser.parse(SpyInterceptors.SpyTraceExcludeJDKInterceptor1.class));
                    interceptorProcessors.addAll(defaultInterceptorClassParser.parse(SpyInterceptors.SpyTraceExcludeJDKInterceptor2.class));
                    interceptorProcessors.addAll(defaultInterceptorClassParser.parse(SpyInterceptors.SpyTraceExcludeJDKInterceptor3.class));
                }
            }
            ArrayList<MethodNode> matchedMethods = new ArrayList<MethodNode>();
            for (MethodNode methodNode : classNode.methods) {
                if (this.isIgnore(methodNode, this.methodNameMatcher)) continue;
                matchedMethods.add(methodNode);
            }
            if (AsmUtils.isEnhancerByCGLIB(className)) {
                for (MethodNode methodNode : matchedMethods) {
                    if (!AsmUtils.isConstructor(methodNode)) continue;
                    AsmUtils.fixConstructorExceptionTable(methodNode);
                }
            }
            GroupLocationFilter groupLocationFilter = new GroupLocationFilter(new LocationFilter[0]);
            InvokeContainLocationFilter enterFilter = new InvokeContainLocationFilter(Type.getInternalName(SpyAPI.class), "atEnter", LocationType.ENTER);
            InvokeContainLocationFilter existFilter = new InvokeContainLocationFilter(Type.getInternalName(SpyAPI.class), "atExit", LocationType.EXIT);
            InvokeContainLocationFilter exceptionFilter = new InvokeContainLocationFilter(Type.getInternalName(SpyAPI.class), "atExceptionExit", LocationType.EXCEPTION_EXIT);
            groupLocationFilter.addFilter(enterFilter);
            groupLocationFilter.addFilter(existFilter);
            groupLocationFilter.addFilter(exceptionFilter);
            InvokeCheckLocationFilter invokeBeforeFilter = new InvokeCheckLocationFilter(Type.getInternalName(SpyAPI.class), "atBeforeInvoke", LocationType.INVOKE);
            InvokeCheckLocationFilter invokeAfterFilter = new InvokeCheckLocationFilter(Type.getInternalName(SpyAPI.class), "atInvokeException", LocationType.INVOKE_COMPLETED);
            InvokeCheckLocationFilter invokeExceptionFilter = new InvokeCheckLocationFilter(Type.getInternalName(SpyAPI.class), "atInvokeException", LocationType.INVOKE_EXCEPTION_EXIT);
            groupLocationFilter.addFilter(invokeBeforeFilter);
            groupLocationFilter.addFilter(invokeAfterFilter);
            groupLocationFilter.addFilter(invokeExceptionFilter);
            for (MethodNode methodNode : matchedMethods) {
                if (AsmUtils.isNative(methodNode)) {
                    logger.info("ignore native method: {}", (Object)AsmUtils.methodDeclaration(Type.getObjectType(classNode.name), methodNode));
                    continue;
                }
                if (AsmUtils.containsMethodInsnNode(methodNode, Type.getInternalName(SpyAPI.class), "atBeforeInvoke")) {
                    for (AbstractInsnNode insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                        if (this.skipJDKTrace && methodInsnNode.owner.startsWith("java/") || AsmOpUtils.isBoxType(Type.getObjectType(methodInsnNode.owner))) continue;
                        AdviceListenerManager.registerTraceAdviceListener(inClassLoader, className, methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc, this.listener);
                    }
                } else {
                    MethodProcessor methodProcessor = new MethodProcessor(classNode, methodNode, groupLocationFilter);
                    for (InterceptorProcessor interceptor : interceptorProcessors) {
                        try {
                            List<Location> locations = interceptor.process(methodProcessor);
                            for (Location location : locations) {
                                if (!(location instanceof MethodInsnNodeWare)) continue;
                                MethodInsnNodeWare methodInsnNodeWare = (MethodInsnNodeWare)((Object)location);
                                MethodInsnNode methodInsnNode = methodInsnNodeWare.methodInsnNode();
                                AdviceListenerManager.registerTraceAdviceListener(inClassLoader, className, methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc, this.listener);
                            }
                        }
                        catch (Throwable e) {
                            logger.error("enhancer error, class: {}, method: {}, interceptor: {}", classNode.name, methodNode.name, interceptor.getClass().getName(), e);
                        }
                    }
                }
                AdviceListenerManager.registerAdviceListener(inClassLoader, className, methodNode.name, methodNode.desc, this.listener);
                this.affect.addMethodAndCount(inClassLoader, className, methodNode.name, methodNode.desc);
            }
            if (AsmUtils.getMajorVersion(classNode.version) < 49) {
                classNode.version = AsmUtils.setMajorVersion(classNode.version, 49);
            }
            byte[] enhanceClassByteArray = AsmUtils.toBytes(classNode, inClassLoader, classReader);
            classBytesCache.put(classBeingRedefined, new Object());
            Enhancer.dumpClassIfNecessary(className, enhanceClassByteArray, this.affect);
            this.affect.cCnt(1);
            return enhanceClassByteArray;
        }
        catch (Throwable t) {
            logger.warn("transform loader[{}]:class[{}] failed.", inClassLoader, className, t);
            this.affect.setThrowable(t);
            return null;
        }
    }

    private boolean isAbstract(int access) {
        return (0x400 & access) == 1024;
    }

    private boolean isIgnore(MethodNode methodNode, Matcher methodNameMatcher) {
        return null == methodNode || this.isAbstract(methodNode.access) || !methodNameMatcher.matching(methodNode.name) || ArthasCheckUtils.isEquals(methodNode.name, "<clinit>");
    }

    private static void dumpClassIfNecessary(String className, byte[] data, EnhancerAffect affect) {
        if (!GlobalOptions.isDump) {
            return;
        }
        File dumpClassFile = new File("./arthas-class-dump/" + className + ".class");
        File classPath = new File(dumpClassFile.getParent());
        if (!classPath.mkdirs() && !classPath.exists()) {
            logger.warn("create dump classpath:{} failed.", (Object)classPath);
            return;
        }
        try {
            FileUtils.writeByteArrayToFile(dumpClassFile, data);
            affect.addClassDumpFile(dumpClassFile);
            if (GlobalOptions.verbose) {
                logger.info("dump enhanced class: {}, path: {}", (Object)className, (Object)dumpClassFile);
            }
        }
        catch (IOException e) {
            logger.warn("dump class:{} to file {} failed.", className, dumpClassFile, e);
        }
    }

    private void filter(Set<Class<?>> classes) {
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> clazz = it.next();
            if (null != clazz && !Enhancer.isSelf(clazz) && !Enhancer.isUnsafeClass(clazz) && !Enhancer.isUnsupportedClass(clazz) && !this.isExclude(clazz)) continue;
            it.remove();
        }
    }

    private boolean isExclude(Class<?> clazz) {
        if (this.classNameExcludeMatcher != null) {
            return this.classNameExcludeMatcher.matching(clazz.getName());
        }
        return false;
    }

    private static boolean isSelf(Class<?> clazz) {
        return null != clazz && ArthasCheckUtils.isEquals(clazz.getClassLoader(), Enhancer.class.getClassLoader());
    }

    private static boolean isUnsafeClass(Class<?> clazz) {
        return !GlobalOptions.isUnsafe && clazz.getClassLoader() == null;
    }

    private static boolean isUnsupportedClass(Class<?> clazz) {
        return clazz.isArray() || clazz.isInterface() && !GlobalOptions.isSupportDefaultMethod || clazz.isEnum() || clazz.equals(Class.class) || clazz.equals(Integer.class) || clazz.equals(Method.class) || ClassUtils.isLambdaClass(clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized EnhancerAffect enhance(Instrumentation inst) throws UnmodifiableClassException {
        this.matchingClasses = GlobalOptions.isDisableSubClass ? SearchUtils.searchClass(inst, this.classNameMatcher) : SearchUtils.searchSubClass(inst, SearchUtils.searchClass(inst, this.classNameMatcher));
        this.filter(this.matchingClasses);
        logger.info("enhance matched classes: {}", (Object)this.matchingClasses);
        this.affect.setTransformer(this);
        try {
            ArthasBootstrap.getInstance().getTransformerManager().addTransformer(this, this.isTracing);
            if (GlobalOptions.isBatchReTransform) {
                int size = this.matchingClasses.size();
                Object[] classArray = new Class[size];
                System.arraycopy(this.matchingClasses.toArray(), 0, classArray, 0, size);
                if (classArray.length <= 0) return this.affect;
                inst.retransformClasses((Class<?>[])classArray);
                logger.info("Success to batch transform classes: " + Arrays.toString(classArray));
                return this.affect;
            }
            Iterator<Class<?>> size = this.matchingClasses.iterator();
            while (size.hasNext()) {
                Class<?> clazz = size.next();
                try {
                    inst.retransformClasses(clazz);
                    logger.info("Success to transform class: " + clazz);
                }
                catch (Throwable t) {
                    logger.warn("retransform {} failed.", (Object)clazz, (Object)t);
                    if (t instanceof UnmodifiableClassException) {
                        throw (UnmodifiableClassException)t;
                    }
                    if (!(t instanceof RuntimeException)) throw new RuntimeException(t);
                    throw (RuntimeException)t;
                }
            }
            return this.affect;
        }
        catch (Throwable e) {
            logger.error("Enhancer error, matchingClasses: {}", (Object)this.matchingClasses, (Object)e);
            this.affect.setThrowable(e);
        }
        return this.affect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EnhancerAffect reset(Instrumentation inst, Matcher classNameMatcher) throws UnmodifiableClassException {
        EnhancerAffect affect = new EnhancerAffect();
        HashSet enhanceClassSet = new HashSet();
        for (Class<?> clazz : classBytesCache.keySet()) {
            if (!classNameMatcher.matching(clazz.getName())) continue;
            enhanceClassSet.add(clazz);
        }
        try {
            Enhancer.enhance(inst, enhanceClassSet);
            logger.info("Success to reset classes: " + enhanceClassSet);
        }
        catch (Throwable throwable) {
            for (Class clazz : enhanceClassSet) {
                classBytesCache.remove(clazz);
                affect.cCnt(1);
            }
            throw throwable;
        }
        for (Class<Object> clazz : enhanceClassSet) {
            classBytesCache.remove(clazz);
            affect.cCnt(1);
        }
        return affect;
    }

    private static void enhance(Instrumentation inst, Set<Class<?>> classes) throws UnmodifiableClassException {
        int size = classes.size();
        Class[] classArray = new Class[size];
        System.arraycopy(classes.toArray(), 0, classArray, 0, size);
        if (classArray.length > 0) {
            inst.retransformClasses(classArray);
        }
    }

    static {
        SpyAPI.setSpy((SpyAPI.AbstractSpy)spyImpl);
    }
}

